/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.ForecastTypesCopier;
import software.amazon.awssdk.services.forecast.model.TimeSeriesReplacementsDataSource;
import software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation;
import software.amazon.awssdk.services.forecast.model.TimeSeriesTransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWhatIfForecastResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeWhatIfForecastResponse> {
    private static final SdkField<String> WHAT_IF_FORECAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhatIfForecastName").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::whatIfForecastName)).setter(DescribeWhatIfForecastResponse.setter(Builder::whatIfForecastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastName").build()}).build();
    private static final SdkField<String> WHAT_IF_FORECAST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhatIfForecastArn").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::whatIfForecastArn)).setter(DescribeWhatIfForecastResponse.setter(Builder::whatIfForecastArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastArn").build()}).build();
    private static final SdkField<String> WHAT_IF_ANALYSIS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhatIfAnalysisArn").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::whatIfAnalysisArn)).setter(DescribeWhatIfForecastResponse.setter(Builder::whatIfAnalysisArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalysisArn").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeRemainingInMinutes").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::estimatedTimeRemainingInMinutes)).setter(DescribeWhatIfForecastResponse.setter(Builder::estimatedTimeRemainingInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::status)).setter(DescribeWhatIfForecastResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::message)).setter(DescribeWhatIfForecastResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::creationTime)).setter(DescribeWhatIfForecastResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::lastModificationTime)).setter(DescribeWhatIfForecastResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<List<TimeSeriesTransformation>> TIME_SERIES_TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeSeriesTransformations").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::timeSeriesTransformations)).setter(DescribeWhatIfForecastResponse.setter(Builder::timeSeriesTransformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesTransformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimeSeriesReplacementsDataSource> TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesReplacementsDataSource").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::timeSeriesReplacementsDataSource)).setter(DescribeWhatIfForecastResponse.setter(Builder::timeSeriesReplacementsDataSource)).constructor(TimeSeriesReplacementsDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesReplacementsDataSource").build()}).build();
    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastTypes").getter(DescribeWhatIfForecastResponse.getter(DescribeWhatIfForecastResponse::forecastTypes)).setter(DescribeWhatIfForecastResponse.setter(Builder::forecastTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_FORECAST_NAME_FIELD, WHAT_IF_FORECAST_ARN_FIELD, WHAT_IF_ANALYSIS_ARN_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, TIME_SERIES_TRANSFORMATIONS_FIELD, TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD, FORECAST_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WhatIfForecastName", WHAT_IF_FORECAST_NAME_FIELD);
            this.put("WhatIfForecastArn", WHAT_IF_FORECAST_ARN_FIELD);
            this.put("WhatIfAnalysisArn", WHAT_IF_ANALYSIS_ARN_FIELD);
            this.put("EstimatedTimeRemainingInMinutes", ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
            this.put("TimeSeriesTransformations", TIME_SERIES_TRANSFORMATIONS_FIELD);
            this.put("TimeSeriesReplacementsDataSource", TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD);
            this.put("ForecastTypes", FORECAST_TYPES_FIELD);
        }
    });
    private final String whatIfForecastName;
    private final String whatIfForecastArn;
    private final String whatIfAnalysisArn;
    private final Long estimatedTimeRemainingInMinutes;
    private final String status;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final List<TimeSeriesTransformation> timeSeriesTransformations;
    private final TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource;
    private final List<String> forecastTypes;

    private DescribeWhatIfForecastResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastName = builder.whatIfForecastName;
        this.whatIfForecastArn = builder.whatIfForecastArn;
        this.whatIfAnalysisArn = builder.whatIfAnalysisArn;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.timeSeriesTransformations = builder.timeSeriesTransformations;
        this.timeSeriesReplacementsDataSource = builder.timeSeriesReplacementsDataSource;
        this.forecastTypes = builder.forecastTypes;
    }

    public final String whatIfForecastName() {
        return this.whatIfForecastName;
    }

    public final String whatIfForecastArn() {
        return this.whatIfForecastArn;
    }

    public final String whatIfAnalysisArn() {
        return this.whatIfAnalysisArn;
    }

    public final Long estimatedTimeRemainingInMinutes() {
        return this.estimatedTimeRemainingInMinutes;
    }

    public final String status() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final boolean hasTimeSeriesTransformations() {
        return this.timeSeriesTransformations != null && !(this.timeSeriesTransformations instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesTransformation> timeSeriesTransformations() {
        return this.timeSeriesTransformations;
    }

    public final TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource() {
        return this.timeSeriesReplacementsDataSource;
    }

    public final boolean hasForecastTypes() {
        return this.forecastTypes != null && !(this.forecastTypes instanceof SdkAutoConstructList);
    }

    public final List<String> forecastTypes() {
        return this.forecastTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.whatIfForecastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.whatIfForecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.whatIfAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeSeriesTransformations() ? this.timeSeriesTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesReplacementsDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastTypes() ? this.forecastTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWhatIfForecastResponse)) {
            return false;
        }
        DescribeWhatIfForecastResponse other = (DescribeWhatIfForecastResponse)((Object)obj);
        return Objects.equals(this.whatIfForecastName(), other.whatIfForecastName()) && Objects.equals(this.whatIfForecastArn(), other.whatIfForecastArn()) && Objects.equals(this.whatIfAnalysisArn(), other.whatIfAnalysisArn()) && Objects.equals(this.estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && this.hasTimeSeriesTransformations() == other.hasTimeSeriesTransformations() && Objects.equals(this.timeSeriesTransformations(), other.timeSeriesTransformations()) && Objects.equals(this.timeSeriesReplacementsDataSource(), other.timeSeriesReplacementsDataSource()) && this.hasForecastTypes() == other.hasForecastTypes() && Objects.equals(this.forecastTypes(), other.forecastTypes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWhatIfForecastResponse").add("WhatIfForecastName", (Object)this.whatIfForecastName()).add("WhatIfForecastArn", (Object)this.whatIfForecastArn()).add("WhatIfAnalysisArn", (Object)this.whatIfAnalysisArn()).add("EstimatedTimeRemainingInMinutes", (Object)this.estimatedTimeRemainingInMinutes()).add("Status", (Object)this.status()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("TimeSeriesTransformations", this.hasTimeSeriesTransformations() ? this.timeSeriesTransformations() : null).add("TimeSeriesReplacementsDataSource", (Object)this.timeSeriesReplacementsDataSource()).add("ForecastTypes", this.hasForecastTypes() ? this.forecastTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WhatIfForecastName": {
                return Optional.ofNullable(clazz.cast(this.whatIfForecastName()));
            }
            case "WhatIfForecastArn": {
                return Optional.ofNullable(clazz.cast(this.whatIfForecastArn()));
            }
            case "WhatIfAnalysisArn": {
                return Optional.ofNullable(clazz.cast(this.whatIfAnalysisArn()));
            }
            case "EstimatedTimeRemainingInMinutes": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeRemainingInMinutes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "TimeSeriesTransformations": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesTransformations()));
            }
            case "TimeSeriesReplacementsDataSource": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesReplacementsDataSource()));
            }
            case "ForecastTypes": {
                return Optional.ofNullable(clazz.cast(this.forecastTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWhatIfForecastResponse, T> g) {
        return obj -> g.apply((DescribeWhatIfForecastResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String whatIfForecastName;
        private String whatIfForecastArn;
        private String whatIfAnalysisArn;
        private Long estimatedTimeRemainingInMinutes;
        private String status;
        private String message;
        private Instant creationTime;
        private Instant lastModificationTime;
        private List<TimeSeriesTransformation> timeSeriesTransformations = DefaultSdkAutoConstructList.getInstance();
        private TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource;
        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWhatIfForecastResponse model) {
            super(model);
            this.whatIfForecastName(model.whatIfForecastName);
            this.whatIfForecastArn(model.whatIfForecastArn);
            this.whatIfAnalysisArn(model.whatIfAnalysisArn);
            this.estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            this.status(model.status);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.timeSeriesTransformations(model.timeSeriesTransformations);
            this.timeSeriesReplacementsDataSource(model.timeSeriesReplacementsDataSource);
            this.forecastTypes(model.forecastTypes);
        }

        public final String getWhatIfForecastName() {
            return this.whatIfForecastName;
        }

        public final void setWhatIfForecastName(String whatIfForecastName) {
            this.whatIfForecastName = whatIfForecastName;
        }

        @Override
        public final Builder whatIfForecastName(String whatIfForecastName) {
            this.whatIfForecastName = whatIfForecastName;
            return this;
        }

        public final String getWhatIfForecastArn() {
            return this.whatIfForecastArn;
        }

        public final void setWhatIfForecastArn(String whatIfForecastArn) {
            this.whatIfForecastArn = whatIfForecastArn;
        }

        @Override
        public final Builder whatIfForecastArn(String whatIfForecastArn) {
            this.whatIfForecastArn = whatIfForecastArn;
            return this;
        }

        public final String getWhatIfAnalysisArn() {
            return this.whatIfAnalysisArn;
        }

        public final void setWhatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
        }

        @Override
        public final Builder whatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return this.estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final List<TimeSeriesTransformation.Builder> getTimeSeriesTransformations() {
            List<TimeSeriesTransformation.Builder> result = TimeSeriesTransformationsCopier.copyToBuilder(this.timeSeriesTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesTransformations(Collection<TimeSeriesTransformation.BuilderImpl> timeSeriesTransformations) {
            this.timeSeriesTransformations = TimeSeriesTransformationsCopier.copyFromBuilder(timeSeriesTransformations);
        }

        @Override
        public final Builder timeSeriesTransformations(Collection<TimeSeriesTransformation> timeSeriesTransformations) {
            this.timeSeriesTransformations = TimeSeriesTransformationsCopier.copy(timeSeriesTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesTransformations(TimeSeriesTransformation ... timeSeriesTransformations) {
            this.timeSeriesTransformations(Arrays.asList(timeSeriesTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesTransformations(Consumer<TimeSeriesTransformation.Builder> ... timeSeriesTransformations) {
            this.timeSeriesTransformations(Stream.of(timeSeriesTransformations).map(c -> (TimeSeriesTransformation)((TimeSeriesTransformation.Builder)TimeSeriesTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimeSeriesReplacementsDataSource.Builder getTimeSeriesReplacementsDataSource() {
            return this.timeSeriesReplacementsDataSource != null ? this.timeSeriesReplacementsDataSource.toBuilder() : null;
        }

        public final void setTimeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource.BuilderImpl timeSeriesReplacementsDataSource) {
            this.timeSeriesReplacementsDataSource = timeSeriesReplacementsDataSource != null ? timeSeriesReplacementsDataSource.build() : null;
        }

        @Override
        public final Builder timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource) {
            this.timeSeriesReplacementsDataSource = timeSeriesReplacementsDataSource;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (this.forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String ... forecastTypes) {
            this.forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        @Override
        public DescribeWhatIfForecastResponse build() {
            return new DescribeWhatIfForecastResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWhatIfForecastResponse> {
        public Builder whatIfForecastName(String var1);

        public Builder whatIfForecastArn(String var1);

        public Builder whatIfAnalysisArn(String var1);

        public Builder estimatedTimeRemainingInMinutes(Long var1);

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder timeSeriesTransformations(Collection<TimeSeriesTransformation> var1);

        public Builder timeSeriesTransformations(TimeSeriesTransformation ... var1);

        public Builder timeSeriesTransformations(Consumer<TimeSeriesTransformation.Builder> ... var1);

        public Builder timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource var1);

        default public Builder timeSeriesReplacementsDataSource(Consumer<TimeSeriesReplacementsDataSource.Builder> timeSeriesReplacementsDataSource) {
            return this.timeSeriesReplacementsDataSource((TimeSeriesReplacementsDataSource)((TimeSeriesReplacementsDataSource.Builder)TimeSeriesReplacementsDataSource.builder().applyMutation(timeSeriesReplacementsDataSource)).build());
        }

        public Builder forecastTypes(Collection<String> var1);

        public Builder forecastTypes(String ... var1);
    }
}

