/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ExplainabilitySummary;
import software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest;
import software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse;

public class ListExplainabilitiesIterable
implements SdkIterable<ListExplainabilitiesResponse> {
    private final ForecastClient client;
    private final ListExplainabilitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExplainabilitiesIterable(ForecastClient client, ListExplainabilitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExplainabilitiesResponseFetcher();
    }

    public Iterator<ListExplainabilitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExplainabilitySummary> explainabilities() {
        Function<ListExplainabilitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.explainabilities() != null) {
                return response.explainabilities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExplainabilitiesResponseFetcher
    implements SyncPageFetcher<ListExplainabilitiesResponse> {
        private ListExplainabilitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListExplainabilitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExplainabilitiesResponse nextPage(ListExplainabilitiesResponse previousPage) {
            if (previousPage == null) {
                return ListExplainabilitiesIterable.this.client.listExplainabilities(ListExplainabilitiesIterable.this.firstRequest);
            }
            return ListExplainabilitiesIterable.this.client.listExplainabilities((ListExplainabilitiesRequest)((Object)ListExplainabilitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

