/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExplainabilityResponse extends ForecastResponse implements
        ToCopyableBuilder<CreateExplainabilityResponse.Builder, CreateExplainabilityResponse> {
    private static final SdkField<String> EXPLAINABILITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityArn").getter(getter(CreateExplainabilityResponse::explainabilityArn))
            .setter(setter(Builder::explainabilityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_ARN_FIELD));

    private final String explainabilityArn;

    private CreateExplainabilityResponse(BuilderImpl builder) {
        super(builder);
        this.explainabilityArn = builder.explainabilityArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Explainability.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Explainability.
     */
    public final String explainabilityArn() {
        return explainabilityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExplainabilityResponse)) {
            return false;
        }
        CreateExplainabilityResponse other = (CreateExplainabilityResponse) obj;
        return Objects.equals(explainabilityArn(), other.explainabilityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExplainabilityResponse").add("ExplainabilityArn", explainabilityArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExplainabilityArn":
            return Optional.ofNullable(clazz.cast(explainabilityArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExplainabilityResponse, T> g) {
        return obj -> g.apply((CreateExplainabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateExplainabilityResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Explainability.
         * </p>
         * 
         * @param explainabilityArn
         *        The Amazon Resource Name (ARN) of the Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityArn(String explainabilityArn);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String explainabilityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExplainabilityResponse model) {
            super(model);
            explainabilityArn(model.explainabilityArn);
        }

        public final String getExplainabilityArn() {
            return explainabilityArn;
        }

        public final void setExplainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
        }

        @Override
        public final Builder explainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
            return this;
        }

        @Override
        public CreateExplainabilityResponse build() {
            return new CreateExplainabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
