/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the method used to transform attributes.
 * </p>
 * <p>
 * The following is an example using the RETAIL domain:
 * </p>
 * <p>
 * <code>{</code>
 * </p>
 * <p>
 * <code>"AttributeName": "demand",</code>
 * </p>
 * <p>
 * <code>"Transformations": {"aggregation": "sum", "middlefill": "zero", "backfill": "zero"}</code>
 * </p>
 * <p>
 * <code>}</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeConfig implements SdkPojo, Serializable, ToCopyableBuilder<AttributeConfig.Builder, AttributeConfig> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(AttributeConfig::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<Map<String, String>> TRANSFORMATIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Transformations")
            .getter(getter(AttributeConfig::transformations))
            .setter(setter(Builder::transformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transformations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            TRANSFORMATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final Map<String, String> transformations;

    private AttributeConfig(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.transformations = builder.transformations;
    }

    /**
     * <p>
     * The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the target
     * time series and the related time series datasets. For example, for the RETAIL domain, the target is
     * <code>demand</code>.
     * </p>
     * 
     * @return The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the
     *         target time series and the related time series datasets. For example, for the RETAIL domain, the target
     *         is <code>demand</code>.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Transformations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransformations() {
        return transformations != null && !(transformations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to
     * override the default values. Related Time Series attributes do not accept aggregation parameters.
     * </p>
     * <p>
     * The following list shows the parameters and their valid values for the "filling" featurization method for a
     * <b>Target Time Series</b> dataset. Default values are bolded.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>frontfill</code>: <b>none</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>,
     * <code>mean</code>, <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization
     * method (there are no defaults):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     * <code>min</code>, <code>max</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the value in
     * a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2, include the
     * following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransformations} method.
     * </p>
     * 
     * @return The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters
     *         to override the default values. Related Time Series attributes do not accept aggregation parameters.</p>
     *         <p>
     *         The following list shows the parameters and their valid values for the "filling" featurization method for
     *         a <b>Target Time Series</b> dataset. Default values are bolded.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>,
     *         <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>frontfill</code>: <b>none</b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>,
     *         <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>,
     *         <code>mean</code>, <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following list shows the parameters and their valid values for a <b>Related Time Series</b>
     *         featurization method (there are no defaults):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
     *         <code>min</code>, <code>max</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the
     *         value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2,
     *         include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
     */
    public final Map<String, String> transformations() {
        return transformations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransformations() ? transformations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeConfig)) {
            return false;
        }
        AttributeConfig other = (AttributeConfig) obj;
        return Objects.equals(attributeName(), other.attributeName()) && hasTransformations() == other.hasTransformations()
                && Objects.equals(transformations(), other.transformations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeConfig").add("AttributeName", attributeName())
                .add("Transformations", hasTransformations() ? transformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Transformations":
            return Optional.ofNullable(clazz.cast(transformations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeConfig, T> g) {
        return obj -> g.apply((AttributeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeConfig> {
        /**
         * <p>
         * The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the target
         * time series and the related time series datasets. For example, for the RETAIL domain, the target is
         * <code>demand</code>.
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute as specified in the schema. Amazon Forecast supports the target field of the
         *        target time series and the related time series datasets. For example, for the RETAIL domain, the
         *        target is <code>demand</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to
         * override the default values. Related Time Series attributes do not accept aggregation parameters.
         * </p>
         * <p>
         * The following list shows the parameters and their valid values for the "filling" featurization method for a
         * <b>Target Time Series</b> dataset. Default values are bolded.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>,
         * <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>frontfill</code>: <b>none</b>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>,
         * <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>,
         * <code>mean</code>, <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization
         * method (there are no defaults):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         * <code>min</code>, <code>max</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To set a filling method to a specific value, set the fill parameter to <code>value</code> and define the
         * value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value of 2,
         * include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
         * </p>
         * 
         * @param transformations
         *        The method parameters (key-value pairs), which are a map of override parameters. Specify these
         *        parameters to override the default values. Related Time Series attributes do not accept aggregation
         *        parameters.</p>
         *        <p>
         *        The following list shows the parameters and their valid values for the "filling" featurization method
         *        for a <b>Target Time Series</b> dataset. Default values are bolded.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>,
         *        <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>frontfill</code>: <b>none</b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>,
         *        <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>,
         *        <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following list shows the parameters and their valid values for a <b>Related Time Series</b>
         *        featurization method (there are no defaults):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>,
         *        <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To set a filling method to a specific value, set the fill parameter to <code>value</code> and define
         *        the value in a corresponding <code>_value</code> parameter. For example, to set backfilling to a value
         *        of 2, include the following: <code>"backfill": "value"</code> and <code>"backfill_value":"2"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformations(Map<String, String> transformations);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private Map<String, String> transformations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeConfig model) {
            attributeName(model.attributeName);
            transformations(model.transformations);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Map<String, String> getTransformations() {
            if (transformations instanceof SdkAutoConstructMap) {
                return null;
            }
            return transformations;
        }

        public final void setTransformations(Map<String, String> transformations) {
            this.transformations = TransformationsCopier.copy(transformations);
        }

        @Override
        public final Builder transformations(Map<String, String> transformations) {
            this.transformations = TransformationsCopier.copy(transformations);
            return this;
        }

        @Override
        public AttributeConfig build() {
            return new AttributeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
