/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ArnListCopier;
import software.amazon.awssdk.services.forecast.model.DataConfig;
import software.amazon.awssdk.services.forecast.model.EncryptionConfig;
import software.amazon.awssdk.services.forecast.model.ExplainabilityInfo;
import software.amazon.awssdk.services.forecast.model.ForecastDimensionsCopier;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.ForecastTypesCopier;
import software.amazon.awssdk.services.forecast.model.MonitorInfo;
import software.amazon.awssdk.services.forecast.model.OptimizationMetric;
import software.amazon.awssdk.services.forecast.model.ReferencePredictorSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutoPredictorResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeAutoPredictorResponse> {
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorArn").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::predictorArn)).setter(DescribeAutoPredictorResponse.setter(Builder::predictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()}).build();
    private static final SdkField<String> PREDICTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorName").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::predictorName)).setter(DescribeAutoPredictorResponse.setter(Builder::predictorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorName").build()}).build();
    private static final SdkField<Integer> FORECAST_HORIZON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ForecastHorizon").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::forecastHorizon)).setter(DescribeAutoPredictorResponse.setter(Builder::forecastHorizon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastHorizon").build()}).build();
    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastTypes").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::forecastTypes)).setter(DescribeAutoPredictorResponse.setter(Builder::forecastTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FORECAST_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastFrequency").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::forecastFrequency)).setter(DescribeAutoPredictorResponse.setter(Builder::forecastFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastFrequency").build()}).build();
    private static final SdkField<List<String>> FORECAST_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastDimensions").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::forecastDimensions)).setter(DescribeAutoPredictorResponse.setter(Builder::forecastDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATASET_IMPORT_JOB_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetImportJobArns").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::datasetImportJobArns)).setter(DescribeAutoPredictorResponse.setter(Builder::datasetImportJobArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataConfig> DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataConfig").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::dataConfig)).setter(DescribeAutoPredictorResponse.setter(Builder::dataConfig)).constructor(DataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataConfig").build()}).build();
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfig").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::encryptionConfig)).setter(DescribeAutoPredictorResponse.setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()}).build();
    private static final SdkField<ReferencePredictorSummary> REFERENCE_PREDICTOR_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReferencePredictorSummary").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::referencePredictorSummary)).setter(DescribeAutoPredictorResponse.setter(Builder::referencePredictorSummary)).constructor(ReferencePredictorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencePredictorSummary").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeRemainingInMinutes").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::estimatedTimeRemainingInMinutes)).setter(DescribeAutoPredictorResponse.setter(Builder::estimatedTimeRemainingInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::status)).setter(DescribeAutoPredictorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::message)).setter(DescribeAutoPredictorResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::creationTime)).setter(DescribeAutoPredictorResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::lastModificationTime)).setter(DescribeAutoPredictorResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<String> OPTIMIZATION_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationMetric").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::optimizationMetricAsString)).setter(DescribeAutoPredictorResponse.setter(Builder::optimizationMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationMetric").build()}).build();
    private static final SdkField<ExplainabilityInfo> EXPLAINABILITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExplainabilityInfo").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::explainabilityInfo)).setter(DescribeAutoPredictorResponse.setter(Builder::explainabilityInfo)).constructor(ExplainabilityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityInfo").build()}).build();
    private static final SdkField<MonitorInfo> MONITOR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitorInfo").getter(DescribeAutoPredictorResponse.getter(DescribeAutoPredictorResponse::monitorInfo)).setter(DescribeAutoPredictorResponse.setter(Builder::monitorInfo)).constructor(MonitorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_ARN_FIELD, PREDICTOR_NAME_FIELD, FORECAST_HORIZON_FIELD, FORECAST_TYPES_FIELD, FORECAST_FREQUENCY_FIELD, FORECAST_DIMENSIONS_FIELD, DATASET_IMPORT_JOB_ARNS_FIELD, DATA_CONFIG_FIELD, ENCRYPTION_CONFIG_FIELD, REFERENCE_PREDICTOR_SUMMARY_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, OPTIMIZATION_METRIC_FIELD, EXPLAINABILITY_INFO_FIELD, MONITOR_INFO_FIELD));
    private final String predictorArn;
    private final String predictorName;
    private final Integer forecastHorizon;
    private final List<String> forecastTypes;
    private final String forecastFrequency;
    private final List<String> forecastDimensions;
    private final List<String> datasetImportJobArns;
    private final DataConfig dataConfig;
    private final EncryptionConfig encryptionConfig;
    private final ReferencePredictorSummary referencePredictorSummary;
    private final Long estimatedTimeRemainingInMinutes;
    private final String status;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final String optimizationMetric;
    private final ExplainabilityInfo explainabilityInfo;
    private final MonitorInfo monitorInfo;

    private DescribeAutoPredictorResponse(BuilderImpl builder) {
        super(builder);
        this.predictorArn = builder.predictorArn;
        this.predictorName = builder.predictorName;
        this.forecastHorizon = builder.forecastHorizon;
        this.forecastTypes = builder.forecastTypes;
        this.forecastFrequency = builder.forecastFrequency;
        this.forecastDimensions = builder.forecastDimensions;
        this.datasetImportJobArns = builder.datasetImportJobArns;
        this.dataConfig = builder.dataConfig;
        this.encryptionConfig = builder.encryptionConfig;
        this.referencePredictorSummary = builder.referencePredictorSummary;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.optimizationMetric = builder.optimizationMetric;
        this.explainabilityInfo = builder.explainabilityInfo;
        this.monitorInfo = builder.monitorInfo;
    }

    public final String predictorArn() {
        return this.predictorArn;
    }

    public final String predictorName() {
        return this.predictorName;
    }

    public final Integer forecastHorizon() {
        return this.forecastHorizon;
    }

    public final boolean hasForecastTypes() {
        return this.forecastTypes != null && !(this.forecastTypes instanceof SdkAutoConstructList);
    }

    public final List<String> forecastTypes() {
        return this.forecastTypes;
    }

    public final String forecastFrequency() {
        return this.forecastFrequency;
    }

    public final boolean hasForecastDimensions() {
        return this.forecastDimensions != null && !(this.forecastDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> forecastDimensions() {
        return this.forecastDimensions;
    }

    public final boolean hasDatasetImportJobArns() {
        return this.datasetImportJobArns != null && !(this.datasetImportJobArns instanceof SdkAutoConstructList);
    }

    public final List<String> datasetImportJobArns() {
        return this.datasetImportJobArns;
    }

    public final DataConfig dataConfig() {
        return this.dataConfig;
    }

    public final EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    public final ReferencePredictorSummary referencePredictorSummary() {
        return this.referencePredictorSummary;
    }

    public final Long estimatedTimeRemainingInMinutes() {
        return this.estimatedTimeRemainingInMinutes;
    }

    public final String status() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final OptimizationMetric optimizationMetric() {
        return OptimizationMetric.fromValue(this.optimizationMetric);
    }

    public final String optimizationMetricAsString() {
        return this.optimizationMetric;
    }

    public final ExplainabilityInfo explainabilityInfo() {
        return this.explainabilityInfo;
    }

    public final MonitorInfo monitorInfo() {
        return this.monitorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastHorizon());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastTypes() ? this.forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastDimensions() ? this.forecastDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetImportJobArns() ? this.datasetImportJobArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.referencePredictorSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainabilityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoPredictorResponse)) {
            return false;
        }
        DescribeAutoPredictorResponse other = (DescribeAutoPredictorResponse)((Object)obj);
        return Objects.equals(this.predictorArn(), other.predictorArn()) && Objects.equals(this.predictorName(), other.predictorName()) && Objects.equals(this.forecastHorizon(), other.forecastHorizon()) && this.hasForecastTypes() == other.hasForecastTypes() && Objects.equals(this.forecastTypes(), other.forecastTypes()) && Objects.equals(this.forecastFrequency(), other.forecastFrequency()) && this.hasForecastDimensions() == other.hasForecastDimensions() && Objects.equals(this.forecastDimensions(), other.forecastDimensions()) && this.hasDatasetImportJobArns() == other.hasDatasetImportJobArns() && Objects.equals(this.datasetImportJobArns(), other.datasetImportJobArns()) && Objects.equals(this.dataConfig(), other.dataConfig()) && Objects.equals(this.encryptionConfig(), other.encryptionConfig()) && Objects.equals(this.referencePredictorSummary(), other.referencePredictorSummary()) && Objects.equals(this.estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.optimizationMetricAsString(), other.optimizationMetricAsString()) && Objects.equals(this.explainabilityInfo(), other.explainabilityInfo()) && Objects.equals(this.monitorInfo(), other.monitorInfo());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAutoPredictorResponse").add("PredictorArn", (Object)this.predictorArn()).add("PredictorName", (Object)this.predictorName()).add("ForecastHorizon", (Object)this.forecastHorizon()).add("ForecastTypes", this.hasForecastTypes() ? this.forecastTypes() : null).add("ForecastFrequency", (Object)this.forecastFrequency()).add("ForecastDimensions", this.hasForecastDimensions() ? this.forecastDimensions() : null).add("DatasetImportJobArns", this.hasDatasetImportJobArns() ? this.datasetImportJobArns() : null).add("DataConfig", (Object)this.dataConfig()).add("EncryptionConfig", (Object)this.encryptionConfig()).add("ReferencePredictorSummary", (Object)this.referencePredictorSummary()).add("EstimatedTimeRemainingInMinutes", (Object)this.estimatedTimeRemainingInMinutes()).add("Status", (Object)this.status()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("OptimizationMetric", (Object)this.optimizationMetricAsString()).add("ExplainabilityInfo", (Object)this.explainabilityInfo()).add("MonitorInfo", (Object)this.monitorInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorArn": {
                return Optional.ofNullable(clazz.cast(this.predictorArn()));
            }
            case "PredictorName": {
                return Optional.ofNullable(clazz.cast(this.predictorName()));
            }
            case "ForecastHorizon": {
                return Optional.ofNullable(clazz.cast(this.forecastHorizon()));
            }
            case "ForecastTypes": {
                return Optional.ofNullable(clazz.cast(this.forecastTypes()));
            }
            case "ForecastFrequency": {
                return Optional.ofNullable(clazz.cast(this.forecastFrequency()));
            }
            case "ForecastDimensions": {
                return Optional.ofNullable(clazz.cast(this.forecastDimensions()));
            }
            case "DatasetImportJobArns": {
                return Optional.ofNullable(clazz.cast(this.datasetImportJobArns()));
            }
            case "DataConfig": {
                return Optional.ofNullable(clazz.cast(this.dataConfig()));
            }
            case "EncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
            case "ReferencePredictorSummary": {
                return Optional.ofNullable(clazz.cast(this.referencePredictorSummary()));
            }
            case "EstimatedTimeRemainingInMinutes": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeRemainingInMinutes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "OptimizationMetric": {
                return Optional.ofNullable(clazz.cast(this.optimizationMetricAsString()));
            }
            case "ExplainabilityInfo": {
                return Optional.ofNullable(clazz.cast(this.explainabilityInfo()));
            }
            case "MonitorInfo": {
                return Optional.ofNullable(clazz.cast(this.monitorInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoPredictorResponse, T> g) {
        return obj -> g.apply((DescribeAutoPredictorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String predictorArn;
        private String predictorName;
        private Integer forecastHorizon;
        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();
        private String forecastFrequency;
        private List<String> forecastDimensions = DefaultSdkAutoConstructList.getInstance();
        private List<String> datasetImportJobArns = DefaultSdkAutoConstructList.getInstance();
        private DataConfig dataConfig;
        private EncryptionConfig encryptionConfig;
        private ReferencePredictorSummary referencePredictorSummary;
        private Long estimatedTimeRemainingInMinutes;
        private String status;
        private String message;
        private Instant creationTime;
        private Instant lastModificationTime;
        private String optimizationMetric;
        private ExplainabilityInfo explainabilityInfo;
        private MonitorInfo monitorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoPredictorResponse model) {
            super(model);
            this.predictorArn(model.predictorArn);
            this.predictorName(model.predictorName);
            this.forecastHorizon(model.forecastHorizon);
            this.forecastTypes(model.forecastTypes);
            this.forecastFrequency(model.forecastFrequency);
            this.forecastDimensions(model.forecastDimensions);
            this.datasetImportJobArns(model.datasetImportJobArns);
            this.dataConfig(model.dataConfig);
            this.encryptionConfig(model.encryptionConfig);
            this.referencePredictorSummary(model.referencePredictorSummary);
            this.estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            this.status(model.status);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.optimizationMetric(model.optimizationMetric);
            this.explainabilityInfo(model.explainabilityInfo);
            this.monitorInfo(model.monitorInfo);
        }

        public final String getPredictorArn() {
            return this.predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final String getPredictorName() {
            return this.predictorName;
        }

        public final void setPredictorName(String predictorName) {
            this.predictorName = predictorName;
        }

        @Override
        public final Builder predictorName(String predictorName) {
            this.predictorName = predictorName;
            return this;
        }

        public final Integer getForecastHorizon() {
            return this.forecastHorizon;
        }

        public final void setForecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
        }

        @Override
        public final Builder forecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (this.forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String ... forecastTypes) {
            this.forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final String getForecastFrequency() {
            return this.forecastFrequency;
        }

        public final void setForecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
        }

        @Override
        public final Builder forecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
            return this;
        }

        public final Collection<String> getForecastDimensions() {
            if (this.forecastDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastDimensions;
        }

        public final void setForecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
        }

        @Override
        public final Builder forecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastDimensions(String ... forecastDimensions) {
            this.forecastDimensions(Arrays.asList(forecastDimensions));
            return this;
        }

        public final Collection<String> getDatasetImportJobArns() {
            if (this.datasetImportJobArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datasetImportJobArns;
        }

        public final void setDatasetImportJobArns(Collection<String> datasetImportJobArns) {
            this.datasetImportJobArns = ArnListCopier.copy(datasetImportJobArns);
        }

        @Override
        public final Builder datasetImportJobArns(Collection<String> datasetImportJobArns) {
            this.datasetImportJobArns = ArnListCopier.copy(datasetImportJobArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobArns(String ... datasetImportJobArns) {
            this.datasetImportJobArns(Arrays.asList(datasetImportJobArns));
            return this;
        }

        public final DataConfig.Builder getDataConfig() {
            return this.dataConfig != null ? this.dataConfig.toBuilder() : null;
        }

        public final void setDataConfig(DataConfig.BuilderImpl dataConfig) {
            this.dataConfig = dataConfig != null ? dataConfig.build() : null;
        }

        @Override
        public final Builder dataConfig(DataConfig dataConfig) {
            this.dataConfig = dataConfig;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return this.encryptionConfig != null ? this.encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final ReferencePredictorSummary.Builder getReferencePredictorSummary() {
            return this.referencePredictorSummary != null ? this.referencePredictorSummary.toBuilder() : null;
        }

        public final void setReferencePredictorSummary(ReferencePredictorSummary.BuilderImpl referencePredictorSummary) {
            this.referencePredictorSummary = referencePredictorSummary != null ? referencePredictorSummary.build() : null;
        }

        @Override
        public final Builder referencePredictorSummary(ReferencePredictorSummary referencePredictorSummary) {
            this.referencePredictorSummary = referencePredictorSummary;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return this.estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getOptimizationMetric() {
            return this.optimizationMetric;
        }

        public final void setOptimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
        }

        @Override
        public final Builder optimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
            return this;
        }

        @Override
        public final Builder optimizationMetric(OptimizationMetric optimizationMetric) {
            this.optimizationMetric(optimizationMetric == null ? null : optimizationMetric.toString());
            return this;
        }

        public final ExplainabilityInfo.Builder getExplainabilityInfo() {
            return this.explainabilityInfo != null ? this.explainabilityInfo.toBuilder() : null;
        }

        public final void setExplainabilityInfo(ExplainabilityInfo.BuilderImpl explainabilityInfo) {
            this.explainabilityInfo = explainabilityInfo != null ? explainabilityInfo.build() : null;
        }

        @Override
        public final Builder explainabilityInfo(ExplainabilityInfo explainabilityInfo) {
            this.explainabilityInfo = explainabilityInfo;
            return this;
        }

        public final MonitorInfo.Builder getMonitorInfo() {
            return this.monitorInfo != null ? this.monitorInfo.toBuilder() : null;
        }

        public final void setMonitorInfo(MonitorInfo.BuilderImpl monitorInfo) {
            this.monitorInfo = monitorInfo != null ? monitorInfo.build() : null;
        }

        @Override
        public final Builder monitorInfo(MonitorInfo monitorInfo) {
            this.monitorInfo = monitorInfo;
            return this;
        }

        @Override
        public DescribeAutoPredictorResponse build() {
            return new DescribeAutoPredictorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutoPredictorResponse> {
        public Builder predictorArn(String var1);

        public Builder predictorName(String var1);

        public Builder forecastHorizon(Integer var1);

        public Builder forecastTypes(Collection<String> var1);

        public Builder forecastTypes(String ... var1);

        public Builder forecastFrequency(String var1);

        public Builder forecastDimensions(Collection<String> var1);

        public Builder forecastDimensions(String ... var1);

        public Builder datasetImportJobArns(Collection<String> var1);

        public Builder datasetImportJobArns(String ... var1);

        public Builder dataConfig(DataConfig var1);

        default public Builder dataConfig(Consumer<DataConfig.Builder> dataConfig) {
            return this.dataConfig((DataConfig)((DataConfig.Builder)DataConfig.builder().applyMutation(dataConfig)).build());
        }

        public Builder encryptionConfig(EncryptionConfig var1);

        default public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return this.encryptionConfig((EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation(encryptionConfig)).build());
        }

        public Builder referencePredictorSummary(ReferencePredictorSummary var1);

        default public Builder referencePredictorSummary(Consumer<ReferencePredictorSummary.Builder> referencePredictorSummary) {
            return this.referencePredictorSummary((ReferencePredictorSummary)((ReferencePredictorSummary.Builder)ReferencePredictorSummary.builder().applyMutation(referencePredictorSummary)).build());
        }

        public Builder estimatedTimeRemainingInMinutes(Long var1);

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder optimizationMetric(String var1);

        public Builder optimizationMetric(OptimizationMetric var1);

        public Builder explainabilityInfo(ExplainabilityInfo var1);

        default public Builder explainabilityInfo(Consumer<ExplainabilityInfo.Builder> explainabilityInfo) {
            return this.explainabilityInfo((ExplainabilityInfo)((ExplainabilityInfo.Builder)ExplainabilityInfo.builder().applyMutation(explainabilityInfo)).build());
        }

        public Builder monitorInfo(MonitorInfo var1);

        default public Builder monitorInfo(Consumer<MonitorInfo.Builder> monitorInfo) {
            return this.monitorInfo((MonitorInfo)((MonitorInfo.Builder)MonitorInfo.builder().applyMutation(monitorInfo)).build());
        }
    }
}

