/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ArnListCopier;
import software.amazon.awssdk.services.forecast.model.Domain;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatasetGroupResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, DescribeDatasetGroupResponse> {
    private static final SdkField<String> DATASET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetGroupName").getter(DescribeDatasetGroupResponse.getter(DescribeDatasetGroupResponse::datasetGroupName)).setter(DescribeDatasetGroupResponse.setter(Builder::datasetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupName").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetGroupArn").getter(DescribeDatasetGroupResponse.getter(DescribeDatasetGroupResponse::datasetGroupArn)).setter(DescribeDatasetGroupResponse.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()}).build();
    private static final SdkField<List<String>> DATASET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetArns").getter(DescribeDatasetGroupResponse.getter(DescribeDatasetGroupResponse::datasetArns)).setter(DescribeDatasetGroupResponse.setter(Builder::datasetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DescribeDatasetGroupResponse.getter(DescribeDatasetGroupResponse::domainAsString)).setter(DescribeDatasetGroupResponse.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDatasetGroupResponse.getter(DescribeDatasetGroupResponse::status)).setter(DescribeDatasetGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeDatasetGroupResponse.getter(DescribeDatasetGroupResponse::creationTime)).setter(DescribeDatasetGroupResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeDatasetGroupResponse.getter(DescribeDatasetGroupResponse::lastModificationTime)).setter(DescribeDatasetGroupResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_NAME_FIELD, DATASET_GROUP_ARN_FIELD, DATASET_ARNS_FIELD, DOMAIN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private final String datasetGroupName;
    private final String datasetGroupArn;
    private final List<String> datasetArns;
    private final String domain;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private DescribeDatasetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.datasetGroupName = builder.datasetGroupName;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.datasetArns = builder.datasetArns;
        this.domain = builder.domain;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public String datasetGroupName() {
        return this.datasetGroupName;
    }

    public String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public boolean hasDatasetArns() {
        return this.datasetArns != null && !(this.datasetArns instanceof SdkAutoConstructList);
    }

    public List<String> datasetArns() {
        return this.datasetArns;
    }

    public Domain domain() {
        return Domain.fromValue(this.domain);
    }

    public String domainAsString() {
        return this.domain;
    }

    public String status() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetArns() ? this.datasetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetGroupResponse)) {
            return false;
        }
        DescribeDatasetGroupResponse other = (DescribeDatasetGroupResponse)((Object)obj);
        return Objects.equals(this.datasetGroupName(), other.datasetGroupName()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && this.hasDatasetArns() == other.hasDatasetArns() && Objects.equals(this.datasetArns(), other.datasetArns()) && Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDatasetGroupResponse").add("DatasetGroupName", (Object)this.datasetGroupName()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("DatasetArns", this.hasDatasetArns() ? this.datasetArns() : null).add("Domain", (Object)this.domainAsString()).add("Status", (Object)this.status()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetGroupName": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupName()));
            }
            case "DatasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "DatasetArns": {
                return Optional.ofNullable(clazz.cast(this.datasetArns()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetGroupResponse, T> g) {
        return obj -> g.apply((DescribeDatasetGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private String datasetGroupName;
        private String datasetGroupArn;
        private List<String> datasetArns = DefaultSdkAutoConstructList.getInstance();
        private String domain;
        private String status;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetGroupResponse model) {
            super(model);
            this.datasetGroupName(model.datasetGroupName);
            this.datasetGroupArn(model.datasetGroupArn);
            this.datasetArns(model.datasetArns);
            this.domain(model.domain);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getDatasetGroupName() {
            return this.datasetGroupName;
        }

        @Override
        public final Builder datasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
            return this;
        }

        public final void setDatasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final Collection<String> getDatasetArns() {
            if (this.datasetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datasetArns;
        }

        @Override
        public final Builder datasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetArns(String ... datasetArns) {
            this.datasetArns(Arrays.asList(datasetArns));
            return this;
        }

        public final void setDatasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DescribeDatasetGroupResponse build() {
            return new DescribeDatasetGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatasetGroupResponse> {
        public Builder datasetGroupName(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder datasetArns(Collection<String> var1);

        public Builder datasetArns(String ... var1);

        public Builder domain(String var1);

        public Builder domain(Domain var1);

        public Builder status(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

