/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.PredictorExecution;
import software.amazon.awssdk.services.forecast.model.PredictorExecutionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictorExecutionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictorExecutionDetails> {
    private static final SdkField<List<PredictorExecution>> PREDICTOR_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredictorExecutions").getter(PredictorExecutionDetails.getter(PredictorExecutionDetails::predictorExecutions)).setter(PredictorExecutionDetails.setter(Builder::predictorExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictorExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_EXECUTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PredictorExecution> predictorExecutions;

    private PredictorExecutionDetails(BuilderImpl builder) {
        this.predictorExecutions = builder.predictorExecutions;
    }

    public boolean hasPredictorExecutions() {
        return this.predictorExecutions != null && !(this.predictorExecutions instanceof SdkAutoConstructList);
    }

    public List<PredictorExecution> predictorExecutions() {
        return this.predictorExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorExecutions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorExecutionDetails)) {
            return false;
        }
        PredictorExecutionDetails other = (PredictorExecutionDetails)obj;
        return Objects.equals(this.predictorExecutions(), other.predictorExecutions());
    }

    public String toString() {
        return ToString.builder((String)"PredictorExecutionDetails").add("PredictorExecutions", this.predictorExecutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorExecutions": {
                return Optional.ofNullable(clazz.cast(this.predictorExecutions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictorExecutionDetails, T> g) {
        return obj -> g.apply((PredictorExecutionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PredictorExecution> predictorExecutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorExecutionDetails model) {
            this.predictorExecutions(model.predictorExecutions);
        }

        public final Collection<PredictorExecution.Builder> getPredictorExecutions() {
            return this.predictorExecutions != null ? (Collection)this.predictorExecutions.stream().map(PredictorExecution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder predictorExecutions(Collection<PredictorExecution> predictorExecutions) {
            this.predictorExecutions = PredictorExecutionsCopier.copy(predictorExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorExecutions(PredictorExecution ... predictorExecutions) {
            this.predictorExecutions(Arrays.asList(predictorExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorExecutions(Consumer<PredictorExecution.Builder> ... predictorExecutions) {
            this.predictorExecutions(Stream.of(predictorExecutions).map(c -> (PredictorExecution)((PredictorExecution.Builder)PredictorExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPredictorExecutions(Collection<PredictorExecution.BuilderImpl> predictorExecutions) {
            this.predictorExecutions = PredictorExecutionsCopier.copyFromBuilder(predictorExecutions);
        }

        public PredictorExecutionDetails build() {
            return new PredictorExecutionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictorExecutionDetails> {
        public Builder predictorExecutions(Collection<PredictorExecution> var1);

        public Builder predictorExecutions(PredictorExecution ... var1);

        public Builder predictorExecutions(Consumer<PredictorExecution.Builder> ... var1);
    }
}

