/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceSetResponse extends FmsResponse implements
        ToCopyableBuilder<GetResourceSetResponse.Builder, GetResourceSetResponse> {
    private static final SdkField<ResourceSet> RESOURCE_SET_FIELD = SdkField.<ResourceSet> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceSet").getter(getter(GetResourceSetResponse::resourceSet)).setter(setter(Builder::resourceSet))
            .constructor(ResourceSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSet").build()).build();

    private static final SdkField<String> RESOURCE_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSetArn").getter(getter(GetResourceSetResponse::resourceSetArn))
            .setter(setter(Builder::resourceSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_FIELD,
            RESOURCE_SET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResourceSet resourceSet;

    private final String resourceSetArn;

    private GetResourceSetResponse(BuilderImpl builder) {
        super(builder);
        this.resourceSet = builder.resourceSet;
        this.resourceSetArn = builder.resourceSetArn;
    }

    /**
     * <p>
     * Information about the specified resource set.
     * </p>
     * 
     * @return Information about the specified resource set.
     */
    public final ResourceSet resourceSet() {
        return resourceSet;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource set.
     */
    public final String resourceSetArn() {
        return resourceSetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceSet());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSetResponse)) {
            return false;
        }
        GetResourceSetResponse other = (GetResourceSetResponse) obj;
        return Objects.equals(resourceSet(), other.resourceSet()) && Objects.equals(resourceSetArn(), other.resourceSetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceSetResponse").add("ResourceSet", resourceSet())
                .add("ResourceSetArn", resourceSetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceSet":
            return Optional.ofNullable(clazz.cast(resourceSet()));
        case "ResourceSetArn":
            return Optional.ofNullable(clazz.cast(resourceSetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceSet", RESOURCE_SET_FIELD);
        map.put("ResourceSetArn", RESOURCE_SET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSetResponse, T> g) {
        return obj -> g.apply((GetResourceSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceSetResponse> {
        /**
         * <p>
         * Information about the specified resource set.
         * </p>
         * 
         * @param resourceSet
         *        Information about the specified resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSet(ResourceSet resourceSet);

        /**
         * <p>
         * Information about the specified resource set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSet.Builder} avoiding the need to
         * create one manually via {@link ResourceSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSet.Builder#build()} is called immediately and its result
         * is passed to {@link #resourceSet(ResourceSet)}.
         * 
         * @param resourceSet
         *        a consumer that will call methods on {@link ResourceSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSet(ResourceSet)
         */
        default Builder resourceSet(Consumer<ResourceSet.Builder> resourceSet) {
            return resourceSet(ResourceSet.builder().applyMutation(resourceSet).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource set.
         * </p>
         * 
         * @param resourceSetArn
         *        The Amazon Resource Name (ARN) of the resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSetArn(String resourceSetArn);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private ResourceSet resourceSet;

        private String resourceSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSetResponse model) {
            super(model);
            resourceSet(model.resourceSet);
            resourceSetArn(model.resourceSetArn);
        }

        public final ResourceSet.Builder getResourceSet() {
            return resourceSet != null ? resourceSet.toBuilder() : null;
        }

        public final void setResourceSet(ResourceSet.BuilderImpl resourceSet) {
            this.resourceSet = resourceSet != null ? resourceSet.build() : null;
        }

        @Override
        public final Builder resourceSet(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
            return this;
        }

        public final String getResourceSetArn() {
            return resourceSetArn;
        }

        public final void setResourceSetArn(String resourceSetArn) {
            this.resourceSetArn = resourceSetArn;
        }

        @Override
        public final Builder resourceSetArn(String resourceSetArn) {
            this.resourceSetArn = resourceSetArn;
            return this;
        }

        @Override
        public GetResourceSetResponse build() {
            return new GetResourceSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
