/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the CreateRouteTable action in Amazon EC2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2CreateRouteTableAction implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2CreateRouteTableAction.Builder, EC2CreateRouteTableAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EC2CreateRouteTableAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ActionTarget> VPC_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("VpcId").getter(getter(EC2CreateRouteTableAction::vpcId)).setter(setter(Builder::vpcId))
            .constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final ActionTarget vpcId;

    private EC2CreateRouteTableAction(BuilderImpl builder) {
        this.description = builder.description;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * A description of the CreateRouteTable action.
     * </p>
     * 
     * @return A description of the CreateRouteTable action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the ID of a VPC.
     * </p>
     * 
     * @return Information about the ID of a VPC.
     */
    public final ActionTarget vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2CreateRouteTableAction)) {
            return false;
        }
        EC2CreateRouteTableAction other = (EC2CreateRouteTableAction) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2CreateRouteTableAction").add("Description", description()).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2CreateRouteTableAction, T> g) {
        return obj -> g.apply((EC2CreateRouteTableAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2CreateRouteTableAction> {
        /**
         * <p>
         * A description of the CreateRouteTable action.
         * </p>
         * 
         * @param description
         *        A description of the CreateRouteTable action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the ID of a VPC.
         * </p>
         * 
         * @param vpcId
         *        Information about the ID of a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(ActionTarget vpcId);

        /**
         * <p>
         * Information about the ID of a VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcId(ActionTarget)}.
         * 
         * @param vpcId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcId(ActionTarget)
         */
        default Builder vpcId(Consumer<ActionTarget.Builder> vpcId) {
            return vpcId(ActionTarget.builder().applyMutation(vpcId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private ActionTarget vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2CreateRouteTableAction model) {
            description(model.description);
            vpcId(model.vpcId);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getVpcId() {
            return vpcId != null ? vpcId.toBuilder() : null;
        }

        public final void setVpcId(ActionTarget.BuilderImpl vpcId) {
            this.vpcId = vpcId != null ? vpcId.build() : null;
        }

        @Override
        public final Builder vpcId(ActionTarget vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public EC2CreateRouteTableAction build() {
            return new EC2CreateRouteTableAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
