/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.ActionTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceNetworkAclAssociationAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplaceNetworkAclAssociationAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ReplaceNetworkAclAssociationAction.getter(ReplaceNetworkAclAssociationAction::description)).setter(ReplaceNetworkAclAssociationAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ActionTarget> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociationId").getter(ReplaceNetworkAclAssociationAction.getter(ReplaceNetworkAclAssociationAction::associationId)).setter(ReplaceNetworkAclAssociationAction.setter(Builder::associationId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<ActionTarget> NETWORK_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkAclId").getter(ReplaceNetworkAclAssociationAction.getter(ReplaceNetworkAclAssociationAction::networkAclId)).setter(ReplaceNetworkAclAssociationAction.setter(Builder::networkAclId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").build()}).build();
    private static final SdkField<Boolean> FMS_CAN_REMEDIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FMSCanRemediate").getter(ReplaceNetworkAclAssociationAction.getter(ReplaceNetworkAclAssociationAction::fmsCanRemediate)).setter(ReplaceNetworkAclAssociationAction.setter(Builder::fmsCanRemediate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FMSCanRemediate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ASSOCIATION_ID_FIELD, NETWORK_ACL_ID_FIELD, FMS_CAN_REMEDIATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplaceNetworkAclAssociationAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final ActionTarget associationId;
    private final ActionTarget networkAclId;
    private final Boolean fmsCanRemediate;

    private ReplaceNetworkAclAssociationAction(BuilderImpl builder) {
        this.description = builder.description;
        this.associationId = builder.associationId;
        this.networkAclId = builder.networkAclId;
        this.fmsCanRemediate = builder.fmsCanRemediate;
    }

    public final String description() {
        return this.description;
    }

    public final ActionTarget associationId() {
        return this.associationId;
    }

    public final ActionTarget networkAclId() {
        return this.networkAclId;
    }

    public final Boolean fmsCanRemediate() {
        return this.fmsCanRemediate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fmsCanRemediate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclAssociationAction)) {
            return false;
        }
        ReplaceNetworkAclAssociationAction other = (ReplaceNetworkAclAssociationAction)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.networkAclId(), other.networkAclId()) && Objects.equals(this.fmsCanRemediate(), other.fmsCanRemediate());
    }

    public final String toString() {
        return ToString.builder((String)"ReplaceNetworkAclAssociationAction").add("Description", (Object)this.description()).add("AssociationId", (Object)this.associationId()).add("NetworkAclId", (Object)this.networkAclId()).add("FMSCanRemediate", (Object)this.fmsCanRemediate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "NetworkAclId": {
                return Optional.ofNullable(clazz.cast(this.networkAclId()));
            }
            case "FMSCanRemediate": {
                return Optional.ofNullable(clazz.cast(this.fmsCanRemediate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("NetworkAclId", NETWORK_ACL_ID_FIELD);
        map.put("FMSCanRemediate", FMS_CAN_REMEDIATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplaceNetworkAclAssociationAction, T> g) {
        return obj -> g.apply((ReplaceNetworkAclAssociationAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private ActionTarget associationId;
        private ActionTarget networkAclId;
        private Boolean fmsCanRemediate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclAssociationAction model) {
            this.description(model.description);
            this.associationId(model.associationId);
            this.networkAclId(model.networkAclId);
            this.fmsCanRemediate(model.fmsCanRemediate);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getAssociationId() {
            return this.associationId != null ? this.associationId.toBuilder() : null;
        }

        public final void setAssociationId(ActionTarget.BuilderImpl associationId) {
            this.associationId = associationId != null ? associationId.build() : null;
        }

        @Override
        public final Builder associationId(ActionTarget associationId) {
            this.associationId = associationId;
            return this;
        }

        public final ActionTarget.Builder getNetworkAclId() {
            return this.networkAclId != null ? this.networkAclId.toBuilder() : null;
        }

        public final void setNetworkAclId(ActionTarget.BuilderImpl networkAclId) {
            this.networkAclId = networkAclId != null ? networkAclId.build() : null;
        }

        @Override
        public final Builder networkAclId(ActionTarget networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final Boolean getFmsCanRemediate() {
            return this.fmsCanRemediate;
        }

        public final void setFmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
        }

        @Override
        public final Builder fmsCanRemediate(Boolean fmsCanRemediate) {
            this.fmsCanRemediate = fmsCanRemediate;
            return this;
        }

        public ReplaceNetworkAclAssociationAction build() {
            return new ReplaceNetworkAclAssociationAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplaceNetworkAclAssociationAction> {
        public Builder description(String var1);

        public Builder associationId(ActionTarget var1);

        default public Builder associationId(Consumer<ActionTarget.Builder> associationId) {
            return this.associationId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(associationId)).build());
        }

        public Builder networkAclId(ActionTarget var1);

        default public Builder networkAclId(Consumer<ActionTarget.Builder> networkAclId) {
            return this.networkAclId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(networkAclId)).build());
        }

        public Builder fmsCanRemediate(Boolean var1);
    }
}

