/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ExpectedRoute;
import software.amazon.awssdk.services.fms.model.ExpectedRoutesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFirewallMissingExpectedRoutesViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFirewallMissingExpectedRoutesViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationTarget").getter(NetworkFirewallMissingExpectedRoutesViolation.getter(NetworkFirewallMissingExpectedRoutesViolation::violationTarget)).setter(NetworkFirewallMissingExpectedRoutesViolation.setter(Builder::violationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()}).build();
    private static final SdkField<List<ExpectedRoute>> EXPECTED_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpectedRoutes").getter(NetworkFirewallMissingExpectedRoutesViolation.getter(NetworkFirewallMissingExpectedRoutesViolation::expectedRoutes)).setter(NetworkFirewallMissingExpectedRoutesViolation.setter(Builder::expectedRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpectedRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(NetworkFirewallMissingExpectedRoutesViolation.getter(NetworkFirewallMissingExpectedRoutesViolation::vpcId)).setter(NetworkFirewallMissingExpectedRoutesViolation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD, EXPECTED_ROUTES_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkFirewallMissingExpectedRoutesViolation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String violationTarget;
    private final List<ExpectedRoute> expectedRoutes;
    private final String vpcId;

    private NetworkFirewallMissingExpectedRoutesViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.expectedRoutes = builder.expectedRoutes;
        this.vpcId = builder.vpcId;
    }

    public final String violationTarget() {
        return this.violationTarget;
    }

    public final boolean hasExpectedRoutes() {
        return this.expectedRoutes != null && !(this.expectedRoutes instanceof SdkAutoConstructList);
    }

    public final List<ExpectedRoute> expectedRoutes() {
        return this.expectedRoutes;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpectedRoutes() ? this.expectedRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallMissingExpectedRoutesViolation)) {
            return false;
        }
        NetworkFirewallMissingExpectedRoutesViolation other = (NetworkFirewallMissingExpectedRoutesViolation)obj;
        return Objects.equals(this.violationTarget(), other.violationTarget()) && this.hasExpectedRoutes() == other.hasExpectedRoutes() && Objects.equals(this.expectedRoutes(), other.expectedRoutes()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFirewallMissingExpectedRoutesViolation").add("ViolationTarget", (Object)this.violationTarget()).add("ExpectedRoutes", this.hasExpectedRoutes() ? this.expectedRoutes() : null).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ViolationTarget": {
                return Optional.ofNullable(clazz.cast(this.violationTarget()));
            }
            case "ExpectedRoutes": {
                return Optional.ofNullable(clazz.cast(this.expectedRoutes()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ViolationTarget", VIOLATION_TARGET_FIELD);
        map.put("ExpectedRoutes", EXPECTED_ROUTES_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallMissingExpectedRoutesViolation, T> g) {
        return obj -> g.apply((NetworkFirewallMissingExpectedRoutesViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationTarget;
        private List<ExpectedRoute> expectedRoutes = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallMissingExpectedRoutesViolation model) {
            this.violationTarget(model.violationTarget);
            this.expectedRoutes(model.expectedRoutes);
            this.vpcId(model.vpcId);
        }

        public final String getViolationTarget() {
            return this.violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final List<ExpectedRoute.Builder> getExpectedRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedRoutes(Collection<ExpectedRoute.BuilderImpl> expectedRoutes) {
            this.expectedRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedRoutes);
        }

        @Override
        public final Builder expectedRoutes(Collection<ExpectedRoute> expectedRoutes) {
            this.expectedRoutes = ExpectedRoutesCopier.copy(expectedRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedRoutes(ExpectedRoute ... expectedRoutes) {
            this.expectedRoutes(Arrays.asList(expectedRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedRoutes(Consumer<ExpectedRoute.Builder> ... expectedRoutes) {
            this.expectedRoutes(Stream.of(expectedRoutes).map(c -> (ExpectedRoute)((ExpectedRoute.Builder)ExpectedRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public NetworkFirewallMissingExpectedRoutesViolation build() {
            return new NetworkFirewallMissingExpectedRoutesViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFirewallMissingExpectedRoutesViolation> {
        public Builder violationTarget(String var1);

        public Builder expectedRoutes(Collection<ExpectedRoute> var1);

        public Builder expectedRoutes(ExpectedRoute ... var1);

        public Builder expectedRoutes(Consumer<ExpectedRoute.Builder> ... var1);

        public Builder vpcId(String var1);
    }
}

