/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.DnsRuleGroupPrioritiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsRuleGroupPriorityConflictViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsRuleGroupPriorityConflictViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationTarget").getter(DnsRuleGroupPriorityConflictViolation.getter(DnsRuleGroupPriorityConflictViolation::violationTarget)).setter(DnsRuleGroupPriorityConflictViolation.setter(Builder::violationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()}).build();
    private static final SdkField<String> VIOLATION_TARGET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViolationTargetDescription").getter(DnsRuleGroupPriorityConflictViolation.getter(DnsRuleGroupPriorityConflictViolation::violationTargetDescription)).setter(DnsRuleGroupPriorityConflictViolation.setter(Builder::violationTargetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTargetDescription").build()}).build();
    private static final SdkField<Integer> CONFLICTING_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConflictingPriority").getter(DnsRuleGroupPriorityConflictViolation.getter(DnsRuleGroupPriorityConflictViolation::conflictingPriority)).setter(DnsRuleGroupPriorityConflictViolation.setter(Builder::conflictingPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictingPriority").build()}).build();
    private static final SdkField<String> CONFLICTING_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConflictingPolicyId").getter(DnsRuleGroupPriorityConflictViolation.getter(DnsRuleGroupPriorityConflictViolation::conflictingPolicyId)).setter(DnsRuleGroupPriorityConflictViolation.setter(Builder::conflictingPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictingPolicyId").build()}).build();
    private static final SdkField<List<Integer>> UNAVAILABLE_PRIORITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnavailablePriorities").getter(DnsRuleGroupPriorityConflictViolation.getter(DnsRuleGroupPriorityConflictViolation::unavailablePriorities)).setter(DnsRuleGroupPriorityConflictViolation.setter(Builder::unavailablePriorities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnavailablePriorities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD, VIOLATION_TARGET_DESCRIPTION_FIELD, CONFLICTING_PRIORITY_FIELD, CONFLICTING_POLICY_ID_FIELD, UNAVAILABLE_PRIORITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DnsRuleGroupPriorityConflictViolation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String violationTarget;
    private final String violationTargetDescription;
    private final Integer conflictingPriority;
    private final String conflictingPolicyId;
    private final List<Integer> unavailablePriorities;

    private DnsRuleGroupPriorityConflictViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.violationTargetDescription = builder.violationTargetDescription;
        this.conflictingPriority = builder.conflictingPriority;
        this.conflictingPolicyId = builder.conflictingPolicyId;
        this.unavailablePriorities = builder.unavailablePriorities;
    }

    public final String violationTarget() {
        return this.violationTarget;
    }

    public final String violationTargetDescription() {
        return this.violationTargetDescription;
    }

    public final Integer conflictingPriority() {
        return this.conflictingPriority;
    }

    public final String conflictingPolicyId() {
        return this.conflictingPolicyId;
    }

    public final boolean hasUnavailablePriorities() {
        return this.unavailablePriorities != null && !(this.unavailablePriorities instanceof SdkAutoConstructList);
    }

    public final List<Integer> unavailablePriorities() {
        return this.unavailablePriorities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationTargetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictingPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictingPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnavailablePriorities() ? this.unavailablePriorities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRuleGroupPriorityConflictViolation)) {
            return false;
        }
        DnsRuleGroupPriorityConflictViolation other = (DnsRuleGroupPriorityConflictViolation)obj;
        return Objects.equals(this.violationTarget(), other.violationTarget()) && Objects.equals(this.violationTargetDescription(), other.violationTargetDescription()) && Objects.equals(this.conflictingPriority(), other.conflictingPriority()) && Objects.equals(this.conflictingPolicyId(), other.conflictingPolicyId()) && this.hasUnavailablePriorities() == other.hasUnavailablePriorities() && Objects.equals(this.unavailablePriorities(), other.unavailablePriorities());
    }

    public final String toString() {
        return ToString.builder((String)"DnsRuleGroupPriorityConflictViolation").add("ViolationTarget", (Object)this.violationTarget()).add("ViolationTargetDescription", (Object)this.violationTargetDescription()).add("ConflictingPriority", (Object)this.conflictingPriority()).add("ConflictingPolicyId", (Object)this.conflictingPolicyId()).add("UnavailablePriorities", this.hasUnavailablePriorities() ? this.unavailablePriorities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ViolationTarget": {
                return Optional.ofNullable(clazz.cast(this.violationTarget()));
            }
            case "ViolationTargetDescription": {
                return Optional.ofNullable(clazz.cast(this.violationTargetDescription()));
            }
            case "ConflictingPriority": {
                return Optional.ofNullable(clazz.cast(this.conflictingPriority()));
            }
            case "ConflictingPolicyId": {
                return Optional.ofNullable(clazz.cast(this.conflictingPolicyId()));
            }
            case "UnavailablePriorities": {
                return Optional.ofNullable(clazz.cast(this.unavailablePriorities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ViolationTarget", VIOLATION_TARGET_FIELD);
        map.put("ViolationTargetDescription", VIOLATION_TARGET_DESCRIPTION_FIELD);
        map.put("ConflictingPriority", CONFLICTING_PRIORITY_FIELD);
        map.put("ConflictingPolicyId", CONFLICTING_POLICY_ID_FIELD);
        map.put("UnavailablePriorities", UNAVAILABLE_PRIORITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsRuleGroupPriorityConflictViolation, T> g) {
        return obj -> g.apply((DnsRuleGroupPriorityConflictViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationTarget;
        private String violationTargetDescription;
        private Integer conflictingPriority;
        private String conflictingPolicyId;
        private List<Integer> unavailablePriorities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DnsRuleGroupPriorityConflictViolation model) {
            this.violationTarget(model.violationTarget);
            this.violationTargetDescription(model.violationTargetDescription);
            this.conflictingPriority(model.conflictingPriority);
            this.conflictingPolicyId(model.conflictingPolicyId);
            this.unavailablePriorities(model.unavailablePriorities);
        }

        public final String getViolationTarget() {
            return this.violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final String getViolationTargetDescription() {
            return this.violationTargetDescription;
        }

        public final void setViolationTargetDescription(String violationTargetDescription) {
            this.violationTargetDescription = violationTargetDescription;
        }

        @Override
        public final Builder violationTargetDescription(String violationTargetDescription) {
            this.violationTargetDescription = violationTargetDescription;
            return this;
        }

        public final Integer getConflictingPriority() {
            return this.conflictingPriority;
        }

        public final void setConflictingPriority(Integer conflictingPriority) {
            this.conflictingPriority = conflictingPriority;
        }

        @Override
        public final Builder conflictingPriority(Integer conflictingPriority) {
            this.conflictingPriority = conflictingPriority;
            return this;
        }

        public final String getConflictingPolicyId() {
            return this.conflictingPolicyId;
        }

        public final void setConflictingPolicyId(String conflictingPolicyId) {
            this.conflictingPolicyId = conflictingPolicyId;
        }

        @Override
        public final Builder conflictingPolicyId(String conflictingPolicyId) {
            this.conflictingPolicyId = conflictingPolicyId;
            return this;
        }

        public final Collection<Integer> getUnavailablePriorities() {
            if (this.unavailablePriorities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unavailablePriorities;
        }

        public final void setUnavailablePriorities(Collection<Integer> unavailablePriorities) {
            this.unavailablePriorities = DnsRuleGroupPrioritiesCopier.copy(unavailablePriorities);
        }

        @Override
        public final Builder unavailablePriorities(Collection<Integer> unavailablePriorities) {
            this.unavailablePriorities = DnsRuleGroupPrioritiesCopier.copy(unavailablePriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unavailablePriorities(Integer ... unavailablePriorities) {
            this.unavailablePriorities(Arrays.asList(unavailablePriorities));
            return this;
        }

        public DnsRuleGroupPriorityConflictViolation build() {
            return new DnsRuleGroupPriorityConflictViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsRuleGroupPriorityConflictViolation> {
        public Builder violationTarget(String var1);

        public Builder violationTargetDescription(String var1);

        public Builder conflictingPriority(Integer var1);

        public Builder conflictingPolicyId(String var1);

        public Builder unavailablePriorities(Collection<Integer> var1);

        public Builder unavailablePriorities(Integer ... var1);
    }
}

