/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceSetStatus {
    ACTIVE("ACTIVE"),
    OUT_OF_ADMIN_SCOPE("OUT_OF_ADMIN_SCOPE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceSetStatus> VALUE_MAP;
    private final String value;

    private ResourceSetStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceSetStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceSetStatus> knownValues() {
        EnumSet<ResourceSetStatus> knownValues = EnumSet.allOf(ResourceSetStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceSetStatus.class, ResourceSetStatus::toString);
    }
}

