/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.fms.DefaultFmsAsyncClient;
import software.amazon.awssdk.services.fms.DefaultFmsBaseClientBuilder;
import software.amazon.awssdk.services.fms.FmsAsyncClient;
import software.amazon.awssdk.services.fms.FmsAsyncClientBuilder;
import software.amazon.awssdk.services.fms.FmsServiceClientConfiguration;
import software.amazon.awssdk.services.fms.endpoints.FmsEndpointProvider;

@SdkInternalApi
final class DefaultFmsAsyncClientBuilder
extends DefaultFmsBaseClientBuilder<FmsAsyncClientBuilder, FmsAsyncClient>
implements FmsAsyncClientBuilder {
    DefaultFmsAsyncClientBuilder() {
    }

    @Override
    public DefaultFmsAsyncClientBuilder endpointProvider(FmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FmsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultFmsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        FmsServiceClientConfiguration serviceClientConfiguration = FmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultFmsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

