/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.ActionTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2CreateRouteTableAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2CreateRouteTableAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EC2CreateRouteTableAction.getter(EC2CreateRouteTableAction::description)).setter(EC2CreateRouteTableAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ActionTarget> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcId").getter(EC2CreateRouteTableAction.getter(EC2CreateRouteTableAction::vpcId)).setter(EC2CreateRouteTableAction.setter(Builder::vpcId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final ActionTarget vpcId;

    private EC2CreateRouteTableAction(BuilderImpl builder) {
        this.description = builder.description;
        this.vpcId = builder.vpcId;
    }

    public final String description() {
        return this.description;
    }

    public final ActionTarget vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2CreateRouteTableAction)) {
            return false;
        }
        EC2CreateRouteTableAction other = (EC2CreateRouteTableAction)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"EC2CreateRouteTableAction").add("Description", (Object)this.description()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2CreateRouteTableAction, T> g) {
        return obj -> g.apply((EC2CreateRouteTableAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private ActionTarget vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2CreateRouteTableAction model) {
            this.description(model.description);
            this.vpcId(model.vpcId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getVpcId() {
            return this.vpcId != null ? this.vpcId.toBuilder() : null;
        }

        public final void setVpcId(ActionTarget.BuilderImpl vpcId) {
            this.vpcId = vpcId != null ? vpcId.build() : null;
        }

        @Override
        public final Builder vpcId(ActionTarget vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public EC2CreateRouteTableAction build() {
            return new EC2CreateRouteTableAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2CreateRouteTableAction> {
        public Builder description(String var1);

        public Builder vpcId(ActionTarget var1);

        default public Builder vpcId(Consumer<ActionTarget.Builder> vpcId) {
            return this.vpcId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(vpcId)).build());
        }
    }
}

