/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DestinationType {
    IPV4("IPV4"),
    IPV6("IPV6"),
    PREFIX_LIST("PREFIX_LIST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DestinationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DestinationType> knownValues() {
        return Stream.of(DestinationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

