/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ExpectedRoute;
import software.amazon.awssdk.services.fms.model.ExpectedRoutesCopier;
import software.amazon.awssdk.services.fms.model.ResourceIdListCopier;
import software.amazon.awssdk.services.fms.model.Route;
import software.amazon.awssdk.services.fms.model.RoutesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFirewallInvalidRouteConfigurationViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFirewallInvalidRouteConfigurationViolation> {
    private static final SdkField<List<String>> AFFECTED_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AffectedSubnets").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::affectedSubnets)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::affectedSubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedSubnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::routeTableId)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final SdkField<Boolean> IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsRouteTableUsedInDifferentAZ").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::isRouteTableUsedInDifferentAZ)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::isRouteTableUsedInDifferentAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRouteTableUsedInDifferentAZ").build()}).build();
    private static final SdkField<Route> VIOLATING_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ViolatingRoute").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::violatingRoute)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::violatingRoute)).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoute").build()}).build();
    private static final SdkField<String> CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentFirewallSubnetRouteTable").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::currentFirewallSubnetRouteTable)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::currentFirewallSubnetRouteTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFirewallSubnetRouteTable").build()}).build();
    private static final SdkField<String> EXPECTED_FIREWALL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedFirewallEndpoint").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::expectedFirewallEndpoint)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::expectedFirewallEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallEndpoint").build()}).build();
    private static final SdkField<String> ACTUAL_FIREWALL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActualFirewallEndpoint").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::actualFirewallEndpoint)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::actualFirewallEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualFirewallEndpoint").build()}).build();
    private static final SdkField<String> EXPECTED_FIREWALL_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedFirewallSubnetId").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::expectedFirewallSubnetId)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::expectedFirewallSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallSubnetId").build()}).build();
    private static final SdkField<String> ACTUAL_FIREWALL_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActualFirewallSubnetId").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::actualFirewallSubnetId)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::actualFirewallSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualFirewallSubnetId").build()}).build();
    private static final SdkField<List<ExpectedRoute>> EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpectedFirewallSubnetRoutes").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::expectedFirewallSubnetRoutes)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::expectedFirewallSubnetRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallSubnetRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpectedRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Route>> ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActualFirewallSubnetRoutes").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::actualFirewallSubnetRoutes)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::actualFirewallSubnetRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualFirewallSubnetRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetGatewayId").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::internetGatewayId)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::internetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayId").build()}).build();
    private static final SdkField<String> CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentInternetGatewayRouteTable").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::currentInternetGatewayRouteTable)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::currentInternetGatewayRouteTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInternetGatewayRouteTable").build()}).build();
    private static final SdkField<List<ExpectedRoute>> EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpectedInternetGatewayRoutes").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::expectedInternetGatewayRoutes)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::expectedInternetGatewayRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedInternetGatewayRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpectedRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Route>> ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActualInternetGatewayRoutes").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::actualInternetGatewayRoutes)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::actualInternetGatewayRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualInternetGatewayRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(NetworkFirewallInvalidRouteConfigurationViolation.getter(NetworkFirewallInvalidRouteConfigurationViolation::vpcId)).setter(NetworkFirewallInvalidRouteConfigurationViolation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_SUBNETS_FIELD, ROUTE_TABLE_ID_FIELD, IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD, VIOLATING_ROUTE_FIELD, CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD, EXPECTED_FIREWALL_ENDPOINT_FIELD, ACTUAL_FIREWALL_ENDPOINT_FIELD, EXPECTED_FIREWALL_SUBNET_ID_FIELD, ACTUAL_FIREWALL_SUBNET_ID_FIELD, EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD, ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD, INTERNET_GATEWAY_ID_FIELD, CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD, EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD, ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD, VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> affectedSubnets;
    private final String routeTableId;
    private final Boolean isRouteTableUsedInDifferentAZ;
    private final Route violatingRoute;
    private final String currentFirewallSubnetRouteTable;
    private final String expectedFirewallEndpoint;
    private final String actualFirewallEndpoint;
    private final String expectedFirewallSubnetId;
    private final String actualFirewallSubnetId;
    private final List<ExpectedRoute> expectedFirewallSubnetRoutes;
    private final List<Route> actualFirewallSubnetRoutes;
    private final String internetGatewayId;
    private final String currentInternetGatewayRouteTable;
    private final List<ExpectedRoute> expectedInternetGatewayRoutes;
    private final List<Route> actualInternetGatewayRoutes;
    private final String vpcId;

    private NetworkFirewallInvalidRouteConfigurationViolation(BuilderImpl builder) {
        this.affectedSubnets = builder.affectedSubnets;
        this.routeTableId = builder.routeTableId;
        this.isRouteTableUsedInDifferentAZ = builder.isRouteTableUsedInDifferentAZ;
        this.violatingRoute = builder.violatingRoute;
        this.currentFirewallSubnetRouteTable = builder.currentFirewallSubnetRouteTable;
        this.expectedFirewallEndpoint = builder.expectedFirewallEndpoint;
        this.actualFirewallEndpoint = builder.actualFirewallEndpoint;
        this.expectedFirewallSubnetId = builder.expectedFirewallSubnetId;
        this.actualFirewallSubnetId = builder.actualFirewallSubnetId;
        this.expectedFirewallSubnetRoutes = builder.expectedFirewallSubnetRoutes;
        this.actualFirewallSubnetRoutes = builder.actualFirewallSubnetRoutes;
        this.internetGatewayId = builder.internetGatewayId;
        this.currentInternetGatewayRouteTable = builder.currentInternetGatewayRouteTable;
        this.expectedInternetGatewayRoutes = builder.expectedInternetGatewayRoutes;
        this.actualInternetGatewayRoutes = builder.actualInternetGatewayRoutes;
        this.vpcId = builder.vpcId;
    }

    public final boolean hasAffectedSubnets() {
        return this.affectedSubnets != null && !(this.affectedSubnets instanceof SdkAutoConstructList);
    }

    public final List<String> affectedSubnets() {
        return this.affectedSubnets;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final Boolean isRouteTableUsedInDifferentAZ() {
        return this.isRouteTableUsedInDifferentAZ;
    }

    public final Route violatingRoute() {
        return this.violatingRoute;
    }

    public final String currentFirewallSubnetRouteTable() {
        return this.currentFirewallSubnetRouteTable;
    }

    public final String expectedFirewallEndpoint() {
        return this.expectedFirewallEndpoint;
    }

    public final String actualFirewallEndpoint() {
        return this.actualFirewallEndpoint;
    }

    public final String expectedFirewallSubnetId() {
        return this.expectedFirewallSubnetId;
    }

    public final String actualFirewallSubnetId() {
        return this.actualFirewallSubnetId;
    }

    public final boolean hasExpectedFirewallSubnetRoutes() {
        return this.expectedFirewallSubnetRoutes != null && !(this.expectedFirewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    public final List<ExpectedRoute> expectedFirewallSubnetRoutes() {
        return this.expectedFirewallSubnetRoutes;
    }

    public final boolean hasActualFirewallSubnetRoutes() {
        return this.actualFirewallSubnetRoutes != null && !(this.actualFirewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> actualFirewallSubnetRoutes() {
        return this.actualFirewallSubnetRoutes;
    }

    public final String internetGatewayId() {
        return this.internetGatewayId;
    }

    public final String currentInternetGatewayRouteTable() {
        return this.currentInternetGatewayRouteTable;
    }

    public final boolean hasExpectedInternetGatewayRoutes() {
        return this.expectedInternetGatewayRoutes != null && !(this.expectedInternetGatewayRoutes instanceof SdkAutoConstructList);
    }

    public final List<ExpectedRoute> expectedInternetGatewayRoutes() {
        return this.expectedInternetGatewayRoutes;
    }

    public final boolean hasActualInternetGatewayRoutes() {
        return this.actualInternetGatewayRoutes != null && !(this.actualInternetGatewayRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> actualInternetGatewayRoutes() {
        return this.actualInternetGatewayRoutes;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAffectedSubnets() ? this.affectedSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRouteTableUsedInDifferentAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.violatingRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentFirewallSubnetRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedFirewallEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualFirewallEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedFirewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualFirewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpectedFirewallSubnetRoutes() ? this.expectedFirewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActualFirewallSubnetRoutes() ? this.actualFirewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInternetGatewayRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpectedInternetGatewayRoutes() ? this.expectedInternetGatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActualInternetGatewayRoutes() ? this.actualInternetGatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallInvalidRouteConfigurationViolation)) {
            return false;
        }
        NetworkFirewallInvalidRouteConfigurationViolation other = (NetworkFirewallInvalidRouteConfigurationViolation)obj;
        return this.hasAffectedSubnets() == other.hasAffectedSubnets() && Objects.equals(this.affectedSubnets(), other.affectedSubnets()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.isRouteTableUsedInDifferentAZ(), other.isRouteTableUsedInDifferentAZ()) && Objects.equals(this.violatingRoute(), other.violatingRoute()) && Objects.equals(this.currentFirewallSubnetRouteTable(), other.currentFirewallSubnetRouteTable()) && Objects.equals(this.expectedFirewallEndpoint(), other.expectedFirewallEndpoint()) && Objects.equals(this.actualFirewallEndpoint(), other.actualFirewallEndpoint()) && Objects.equals(this.expectedFirewallSubnetId(), other.expectedFirewallSubnetId()) && Objects.equals(this.actualFirewallSubnetId(), other.actualFirewallSubnetId()) && this.hasExpectedFirewallSubnetRoutes() == other.hasExpectedFirewallSubnetRoutes() && Objects.equals(this.expectedFirewallSubnetRoutes(), other.expectedFirewallSubnetRoutes()) && this.hasActualFirewallSubnetRoutes() == other.hasActualFirewallSubnetRoutes() && Objects.equals(this.actualFirewallSubnetRoutes(), other.actualFirewallSubnetRoutes()) && Objects.equals(this.internetGatewayId(), other.internetGatewayId()) && Objects.equals(this.currentInternetGatewayRouteTable(), other.currentInternetGatewayRouteTable()) && this.hasExpectedInternetGatewayRoutes() == other.hasExpectedInternetGatewayRoutes() && Objects.equals(this.expectedInternetGatewayRoutes(), other.expectedInternetGatewayRoutes()) && this.hasActualInternetGatewayRoutes() == other.hasActualInternetGatewayRoutes() && Objects.equals(this.actualInternetGatewayRoutes(), other.actualInternetGatewayRoutes()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFirewallInvalidRouteConfigurationViolation").add("AffectedSubnets", this.hasAffectedSubnets() ? this.affectedSubnets() : null).add("RouteTableId", (Object)this.routeTableId()).add("IsRouteTableUsedInDifferentAZ", (Object)this.isRouteTableUsedInDifferentAZ()).add("ViolatingRoute", (Object)this.violatingRoute()).add("CurrentFirewallSubnetRouteTable", (Object)this.currentFirewallSubnetRouteTable()).add("ExpectedFirewallEndpoint", (Object)this.expectedFirewallEndpoint()).add("ActualFirewallEndpoint", (Object)this.actualFirewallEndpoint()).add("ExpectedFirewallSubnetId", (Object)this.expectedFirewallSubnetId()).add("ActualFirewallSubnetId", (Object)this.actualFirewallSubnetId()).add("ExpectedFirewallSubnetRoutes", this.hasExpectedFirewallSubnetRoutes() ? this.expectedFirewallSubnetRoutes() : null).add("ActualFirewallSubnetRoutes", this.hasActualFirewallSubnetRoutes() ? this.actualFirewallSubnetRoutes() : null).add("InternetGatewayId", (Object)this.internetGatewayId()).add("CurrentInternetGatewayRouteTable", (Object)this.currentInternetGatewayRouteTable()).add("ExpectedInternetGatewayRoutes", this.hasExpectedInternetGatewayRoutes() ? this.expectedInternetGatewayRoutes() : null).add("ActualInternetGatewayRoutes", this.hasActualInternetGatewayRoutes() ? this.actualInternetGatewayRoutes() : null).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AffectedSubnets": {
                return Optional.ofNullable(clazz.cast(this.affectedSubnets()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "IsRouteTableUsedInDifferentAZ": {
                return Optional.ofNullable(clazz.cast(this.isRouteTableUsedInDifferentAZ()));
            }
            case "ViolatingRoute": {
                return Optional.ofNullable(clazz.cast(this.violatingRoute()));
            }
            case "CurrentFirewallSubnetRouteTable": {
                return Optional.ofNullable(clazz.cast(this.currentFirewallSubnetRouteTable()));
            }
            case "ExpectedFirewallEndpoint": {
                return Optional.ofNullable(clazz.cast(this.expectedFirewallEndpoint()));
            }
            case "ActualFirewallEndpoint": {
                return Optional.ofNullable(clazz.cast(this.actualFirewallEndpoint()));
            }
            case "ExpectedFirewallSubnetId": {
                return Optional.ofNullable(clazz.cast(this.expectedFirewallSubnetId()));
            }
            case "ActualFirewallSubnetId": {
                return Optional.ofNullable(clazz.cast(this.actualFirewallSubnetId()));
            }
            case "ExpectedFirewallSubnetRoutes": {
                return Optional.ofNullable(clazz.cast(this.expectedFirewallSubnetRoutes()));
            }
            case "ActualFirewallSubnetRoutes": {
                return Optional.ofNullable(clazz.cast(this.actualFirewallSubnetRoutes()));
            }
            case "InternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayId()));
            }
            case "CurrentInternetGatewayRouteTable": {
                return Optional.ofNullable(clazz.cast(this.currentInternetGatewayRouteTable()));
            }
            case "ExpectedInternetGatewayRoutes": {
                return Optional.ofNullable(clazz.cast(this.expectedInternetGatewayRoutes()));
            }
            case "ActualInternetGatewayRoutes": {
                return Optional.ofNullable(clazz.cast(this.actualInternetGatewayRoutes()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallInvalidRouteConfigurationViolation, T> g) {
        return obj -> g.apply((NetworkFirewallInvalidRouteConfigurationViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> affectedSubnets = DefaultSdkAutoConstructList.getInstance();
        private String routeTableId;
        private Boolean isRouteTableUsedInDifferentAZ;
        private Route violatingRoute;
        private String currentFirewallSubnetRouteTable;
        private String expectedFirewallEndpoint;
        private String actualFirewallEndpoint;
        private String expectedFirewallSubnetId;
        private String actualFirewallSubnetId;
        private List<ExpectedRoute> expectedFirewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();
        private List<Route> actualFirewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();
        private String internetGatewayId;
        private String currentInternetGatewayRouteTable;
        private List<ExpectedRoute> expectedInternetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();
        private List<Route> actualInternetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallInvalidRouteConfigurationViolation model) {
            this.affectedSubnets(model.affectedSubnets);
            this.routeTableId(model.routeTableId);
            this.isRouteTableUsedInDifferentAZ(model.isRouteTableUsedInDifferentAZ);
            this.violatingRoute(model.violatingRoute);
            this.currentFirewallSubnetRouteTable(model.currentFirewallSubnetRouteTable);
            this.expectedFirewallEndpoint(model.expectedFirewallEndpoint);
            this.actualFirewallEndpoint(model.actualFirewallEndpoint);
            this.expectedFirewallSubnetId(model.expectedFirewallSubnetId);
            this.actualFirewallSubnetId(model.actualFirewallSubnetId);
            this.expectedFirewallSubnetRoutes(model.expectedFirewallSubnetRoutes);
            this.actualFirewallSubnetRoutes(model.actualFirewallSubnetRoutes);
            this.internetGatewayId(model.internetGatewayId);
            this.currentInternetGatewayRouteTable(model.currentInternetGatewayRouteTable);
            this.expectedInternetGatewayRoutes(model.expectedInternetGatewayRoutes);
            this.actualInternetGatewayRoutes(model.actualInternetGatewayRoutes);
            this.vpcId(model.vpcId);
        }

        public final Collection<String> getAffectedSubnets() {
            if (this.affectedSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.affectedSubnets;
        }

        @Override
        public final Builder affectedSubnets(Collection<String> affectedSubnets) {
            this.affectedSubnets = ResourceIdListCopier.copy(affectedSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder affectedSubnets(String ... affectedSubnets) {
            this.affectedSubnets(Arrays.asList(affectedSubnets));
            return this;
        }

        public final void setAffectedSubnets(Collection<String> affectedSubnets) {
            this.affectedSubnets = ResourceIdListCopier.copy(affectedSubnets);
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final Boolean getIsRouteTableUsedInDifferentAZ() {
            return this.isRouteTableUsedInDifferentAZ;
        }

        @Override
        public final Builder isRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ) {
            this.isRouteTableUsedInDifferentAZ = isRouteTableUsedInDifferentAZ;
            return this;
        }

        public final void setIsRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ) {
            this.isRouteTableUsedInDifferentAZ = isRouteTableUsedInDifferentAZ;
        }

        public final Route.Builder getViolatingRoute() {
            return this.violatingRoute != null ? this.violatingRoute.toBuilder() : null;
        }

        @Override
        public final Builder violatingRoute(Route violatingRoute) {
            this.violatingRoute = violatingRoute;
            return this;
        }

        public final void setViolatingRoute(Route.BuilderImpl violatingRoute) {
            this.violatingRoute = violatingRoute != null ? violatingRoute.build() : null;
        }

        public final String getCurrentFirewallSubnetRouteTable() {
            return this.currentFirewallSubnetRouteTable;
        }

        @Override
        public final Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
            return this;
        }

        public final void setCurrentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
        }

        public final String getExpectedFirewallEndpoint() {
            return this.expectedFirewallEndpoint;
        }

        @Override
        public final Builder expectedFirewallEndpoint(String expectedFirewallEndpoint) {
            this.expectedFirewallEndpoint = expectedFirewallEndpoint;
            return this;
        }

        public final void setExpectedFirewallEndpoint(String expectedFirewallEndpoint) {
            this.expectedFirewallEndpoint = expectedFirewallEndpoint;
        }

        public final String getActualFirewallEndpoint() {
            return this.actualFirewallEndpoint;
        }

        @Override
        public final Builder actualFirewallEndpoint(String actualFirewallEndpoint) {
            this.actualFirewallEndpoint = actualFirewallEndpoint;
            return this;
        }

        public final void setActualFirewallEndpoint(String actualFirewallEndpoint) {
            this.actualFirewallEndpoint = actualFirewallEndpoint;
        }

        public final String getExpectedFirewallSubnetId() {
            return this.expectedFirewallSubnetId;
        }

        @Override
        public final Builder expectedFirewallSubnetId(String expectedFirewallSubnetId) {
            this.expectedFirewallSubnetId = expectedFirewallSubnetId;
            return this;
        }

        public final void setExpectedFirewallSubnetId(String expectedFirewallSubnetId) {
            this.expectedFirewallSubnetId = expectedFirewallSubnetId;
        }

        public final String getActualFirewallSubnetId() {
            return this.actualFirewallSubnetId;
        }

        @Override
        public final Builder actualFirewallSubnetId(String actualFirewallSubnetId) {
            this.actualFirewallSubnetId = actualFirewallSubnetId;
            return this;
        }

        public final void setActualFirewallSubnetId(String actualFirewallSubnetId) {
            this.actualFirewallSubnetId = actualFirewallSubnetId;
        }

        public final List<ExpectedRoute.Builder> getExpectedFirewallSubnetRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedFirewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder expectedFirewallSubnetRoutes(Collection<ExpectedRoute> expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes = ExpectedRoutesCopier.copy(expectedFirewallSubnetRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedFirewallSubnetRoutes(ExpectedRoute ... expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes(Arrays.asList(expectedFirewallSubnetRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedFirewallSubnetRoutes(Consumer<ExpectedRoute.Builder> ... expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes(Stream.of(expectedFirewallSubnetRoutes).map(c -> (ExpectedRoute)((ExpectedRoute.Builder)ExpectedRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExpectedFirewallSubnetRoutes(Collection<ExpectedRoute.BuilderImpl> expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedFirewallSubnetRoutes);
        }

        public final List<Route.Builder> getActualFirewallSubnetRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.actualFirewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder actualFirewallSubnetRoutes(Collection<Route> actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes = RoutesCopier.copy(actualFirewallSubnetRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualFirewallSubnetRoutes(Route ... actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes(Arrays.asList(actualFirewallSubnetRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualFirewallSubnetRoutes(Consumer<Route.Builder> ... actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes(Stream.of(actualFirewallSubnetRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActualFirewallSubnetRoutes(Collection<Route.BuilderImpl> actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes = RoutesCopier.copyFromBuilder(actualFirewallSubnetRoutes);
        }

        public final String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        public final String getCurrentInternetGatewayRouteTable() {
            return this.currentInternetGatewayRouteTable;
        }

        @Override
        public final Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
            return this;
        }

        public final void setCurrentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
        }

        public final List<ExpectedRoute.Builder> getExpectedInternetGatewayRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedInternetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder expectedInternetGatewayRoutes(Collection<ExpectedRoute> expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes = ExpectedRoutesCopier.copy(expectedInternetGatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedInternetGatewayRoutes(ExpectedRoute ... expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes(Arrays.asList(expectedInternetGatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedInternetGatewayRoutes(Consumer<ExpectedRoute.Builder> ... expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes(Stream.of(expectedInternetGatewayRoutes).map(c -> (ExpectedRoute)((ExpectedRoute.Builder)ExpectedRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExpectedInternetGatewayRoutes(Collection<ExpectedRoute.BuilderImpl> expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedInternetGatewayRoutes);
        }

        public final List<Route.Builder> getActualInternetGatewayRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.actualInternetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder actualInternetGatewayRoutes(Collection<Route> actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes = RoutesCopier.copy(actualInternetGatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualInternetGatewayRoutes(Route ... actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes(Arrays.asList(actualInternetGatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualInternetGatewayRoutes(Consumer<Route.Builder> ... actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes(Stream.of(actualInternetGatewayRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActualInternetGatewayRoutes(Collection<Route.BuilderImpl> actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes = RoutesCopier.copyFromBuilder(actualInternetGatewayRoutes);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public NetworkFirewallInvalidRouteConfigurationViolation build() {
            return new NetworkFirewallInvalidRouteConfigurationViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFirewallInvalidRouteConfigurationViolation> {
        public Builder affectedSubnets(Collection<String> var1);

        public Builder affectedSubnets(String ... var1);

        public Builder routeTableId(String var1);

        public Builder isRouteTableUsedInDifferentAZ(Boolean var1);

        public Builder violatingRoute(Route var1);

        default public Builder violatingRoute(Consumer<Route.Builder> violatingRoute) {
            return this.violatingRoute((Route)((Route.Builder)Route.builder().applyMutation(violatingRoute)).build());
        }

        public Builder currentFirewallSubnetRouteTable(String var1);

        public Builder expectedFirewallEndpoint(String var1);

        public Builder actualFirewallEndpoint(String var1);

        public Builder expectedFirewallSubnetId(String var1);

        public Builder actualFirewallSubnetId(String var1);

        public Builder expectedFirewallSubnetRoutes(Collection<ExpectedRoute> var1);

        public Builder expectedFirewallSubnetRoutes(ExpectedRoute ... var1);

        public Builder expectedFirewallSubnetRoutes(Consumer<ExpectedRoute.Builder> ... var1);

        public Builder actualFirewallSubnetRoutes(Collection<Route> var1);

        public Builder actualFirewallSubnetRoutes(Route ... var1);

        public Builder actualFirewallSubnetRoutes(Consumer<Route.Builder> ... var1);

        public Builder internetGatewayId(String var1);

        public Builder currentInternetGatewayRouteTable(String var1);

        public Builder expectedInternetGatewayRoutes(Collection<ExpectedRoute> var1);

        public Builder expectedInternetGatewayRoutes(ExpectedRoute ... var1);

        public Builder expectedInternetGatewayRoutes(Consumer<ExpectedRoute.Builder> ... var1);

        public Builder actualInternetGatewayRoutes(Collection<Route> var1);

        public Builder actualInternetGatewayRoutes(Route ... var1);

        public Builder actualInternetGatewayRoutes(Consumer<Route.Builder> ... var1);

        public Builder vpcId(String var1);
    }
}

