/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SecurityServiceType {
    WAF("WAF"),
    WAFV2("WAFV2"),
    SHIELD_ADVANCED("SHIELD_ADVANCED"),
    SECURITY_GROUPS_COMMON("SECURITY_GROUPS_COMMON"),
    SECURITY_GROUPS_CONTENT_AUDIT("SECURITY_GROUPS_CONTENT_AUDIT"),
    SECURITY_GROUPS_USAGE_AUDIT("SECURITY_GROUPS_USAGE_AUDIT"),
    NETWORK_FIREWALL("NETWORK_FIREWALL"),
    DNS_FIREWALL("DNS_FIREWALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SecurityServiceType> VALUE_MAP;
    private final String value;

    private SecurityServiceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecurityServiceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecurityServiceType> knownValues() {
        EnumSet<SecurityServiceType> knownValues = EnumSet.allOf(SecurityServiceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SecurityServiceType.class, SecurityServiceType::toString);
    }
}

