/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsClient;
import software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse;

public class ListMemberAccountsIterable
implements SdkIterable<ListMemberAccountsResponse> {
    private final FmsClient client;
    private final ListMemberAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMemberAccountsIterable(FmsClient client, ListMemberAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMemberAccountsResponseFetcher();
    }

    public Iterator<ListMemberAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> memberAccounts() {
        Function<ListMemberAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.memberAccounts() != null) {
                return response.memberAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMemberAccountsResponseFetcher
    implements SyncPageFetcher<ListMemberAccountsResponse> {
        private ListMemberAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListMemberAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMemberAccountsResponse nextPage(ListMemberAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListMemberAccountsIterable.this.client.listMemberAccounts(ListMemberAccountsIterable.this.firstRequest);
            }
            return ListMemberAccountsIterable.this.client.listMemberAccounts((ListMemberAccountsRequest)((Object)ListMemberAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

