/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPolicyResponse extends FmsResponse implements
        ToCopyableBuilder<GetPolicyResponse.Builder, GetPolicyResponse> {
    private static final SdkField<Policy> POLICY_FIELD = SdkField.<Policy> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetPolicyResponse::policy)).setter(setter(Builder::policy)).constructor(Policy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPolicyResponse::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(POLICY_FIELD, POLICY_ARN_FIELD));

    private final Policy policy;

    private final String policyArn;

    private GetPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.policyArn = builder.policyArn;
    }

    /**
     * <p>
     * Information about the specified AWS Firewall Manager policy.
     * </p>
     * 
     * @return Information about the specified AWS Firewall Manager policy.
     */
    public Policy policy() {
        return policy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified policy.
     */
    public String policyArn() {
        return policyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyResponse)) {
            return false;
        }
        GetPolicyResponse other = (GetPolicyResponse) obj;
        return Objects.equals(policy(), other.policy()) && Objects.equals(policyArn(), other.policyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPolicyResponse").add("Policy", policy()).add("PolicyArn", policyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyResponse, T> g) {
        return obj -> g.apply((GetPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPolicyResponse> {
        /**
         * <p>
         * Information about the specified AWS Firewall Manager policy.
         * </p>
         * 
         * @param policy
         *        Information about the specified AWS Firewall Manager policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(Policy policy);

        /**
         * <p>
         * Information about the specified AWS Firewall Manager policy.
         * </p>
         * This is a convenience that creates an instance of the {@link Policy.Builder} avoiding the need to create one
         * manually via {@link Policy#builder()}.
         *
         * When the {@link Consumer} completes, {@link Policy.Builder#build()} is called immediately and its result is
         * passed to {@link #policy(Policy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link Policy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(Policy)
         */
        default Builder policy(Consumer<Policy.Builder> policy) {
            return policy(Policy.builder().applyMutation(policy).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the specified policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private Policy policy;

        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyResponse model) {
            super(model);
            policy(model.policy);
            policyArn(model.policyArn);
        }

        public final Policy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        @Override
        public final Builder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(Policy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public GetPolicyResponse build() {
            return new GetPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
