/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data sources for the experiment report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentTemplateReportConfigurationDataSources
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ExperimentTemplateReportConfigurationDataSources.Builder, ExperimentTemplateReportConfigurationDataSources> {
    private static final SdkField<List<ExperimentTemplateReportConfigurationCloudWatchDashboard>> CLOUD_WATCH_DASHBOARDS_FIELD = SdkField
            .<List<ExperimentTemplateReportConfigurationCloudWatchDashboard>> builder(MarshallingType.LIST)
            .memberName("cloudWatchDashboards")
            .getter(getter(ExperimentTemplateReportConfigurationDataSources::cloudWatchDashboards))
            .setter(setter(Builder::cloudWatchDashboards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchDashboards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentTemplateReportConfigurationCloudWatchDashboard> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTemplateReportConfigurationCloudWatchDashboard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_DASHBOARDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ExperimentTemplateReportConfigurationCloudWatchDashboard> cloudWatchDashboards;

    private ExperimentTemplateReportConfigurationDataSources(BuilderImpl builder) {
        this.cloudWatchDashboards = builder.cloudWatchDashboards;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchDashboards property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCloudWatchDashboards() {
        return cloudWatchDashboards != null && !(cloudWatchDashboards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CloudWatch dashboards to include as data sources in the experiment report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchDashboards} method.
     * </p>
     * 
     * @return The CloudWatch dashboards to include as data sources in the experiment report.
     */
    public final List<ExperimentTemplateReportConfigurationCloudWatchDashboard> cloudWatchDashboards() {
        return cloudWatchDashboards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudWatchDashboards() ? cloudWatchDashboards() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplateReportConfigurationDataSources)) {
            return false;
        }
        ExperimentTemplateReportConfigurationDataSources other = (ExperimentTemplateReportConfigurationDataSources) obj;
        return hasCloudWatchDashboards() == other.hasCloudWatchDashboards()
                && Objects.equals(cloudWatchDashboards(), other.cloudWatchDashboards());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentTemplateReportConfigurationDataSources")
                .add("CloudWatchDashboards", hasCloudWatchDashboards() ? cloudWatchDashboards() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchDashboards":
            return Optional.ofNullable(clazz.cast(cloudWatchDashboards()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudWatchDashboards", CLOUD_WATCH_DASHBOARDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTemplateReportConfigurationDataSources, T> g) {
        return obj -> g.apply((ExperimentTemplateReportConfigurationDataSources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentTemplateReportConfigurationDataSources> {
        /**
         * <p>
         * The CloudWatch dashboards to include as data sources in the experiment report.
         * </p>
         * 
         * @param cloudWatchDashboards
         *        The CloudWatch dashboards to include as data sources in the experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchDashboards(Collection<ExperimentTemplateReportConfigurationCloudWatchDashboard> cloudWatchDashboards);

        /**
         * <p>
         * The CloudWatch dashboards to include as data sources in the experiment report.
         * </p>
         * 
         * @param cloudWatchDashboards
         *        The CloudWatch dashboards to include as data sources in the experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchDashboards(ExperimentTemplateReportConfigurationCloudWatchDashboard... cloudWatchDashboards);

        /**
         * <p>
         * The CloudWatch dashboards to include as data sources in the experiment report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fis.model.ExperimentTemplateReportConfigurationCloudWatchDashboard.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fis.model.ExperimentTemplateReportConfigurationCloudWatchDashboard#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fis.model.ExperimentTemplateReportConfigurationCloudWatchDashboard.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #cloudWatchDashboards(List<ExperimentTemplateReportConfigurationCloudWatchDashboard>)}.
         * 
         * @param cloudWatchDashboards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fis.model.ExperimentTemplateReportConfigurationCloudWatchDashboard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchDashboards(java.util.Collection<ExperimentTemplateReportConfigurationCloudWatchDashboard>)
         */
        Builder cloudWatchDashboards(
                Consumer<ExperimentTemplateReportConfigurationCloudWatchDashboard.Builder>... cloudWatchDashboards);
    }

    static final class BuilderImpl implements Builder {
        private List<ExperimentTemplateReportConfigurationCloudWatchDashboard> cloudWatchDashboards = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTemplateReportConfigurationDataSources model) {
            cloudWatchDashboards(model.cloudWatchDashboards);
        }

        public final List<ExperimentTemplateReportConfigurationCloudWatchDashboard.Builder> getCloudWatchDashboards() {
            List<ExperimentTemplateReportConfigurationCloudWatchDashboard.Builder> result = ExperimentTemplateReportConfigurationCloudWatchDashboardListCopier
                    .copyToBuilder(this.cloudWatchDashboards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchDashboards(
                Collection<ExperimentTemplateReportConfigurationCloudWatchDashboard.BuilderImpl> cloudWatchDashboards) {
            this.cloudWatchDashboards = ExperimentTemplateReportConfigurationCloudWatchDashboardListCopier
                    .copyFromBuilder(cloudWatchDashboards);
        }

        @Override
        public final Builder cloudWatchDashboards(
                Collection<ExperimentTemplateReportConfigurationCloudWatchDashboard> cloudWatchDashboards) {
            this.cloudWatchDashboards = ExperimentTemplateReportConfigurationCloudWatchDashboardListCopier
                    .copy(cloudWatchDashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchDashboards(
                ExperimentTemplateReportConfigurationCloudWatchDashboard... cloudWatchDashboards) {
            cloudWatchDashboards(Arrays.asList(cloudWatchDashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchDashboards(
                Consumer<ExperimentTemplateReportConfigurationCloudWatchDashboard.Builder>... cloudWatchDashboards) {
            cloudWatchDashboards(Stream.of(cloudWatchDashboards)
                    .map(c -> ExperimentTemplateReportConfigurationCloudWatchDashboard.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExperimentTemplateReportConfigurationDataSources build() {
            return new ExperimentTemplateReportConfigurationDataSources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
