/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of the experiment report generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentReportState implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentReportState.Builder, ExperimentReportState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ExperimentReportState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ExperimentReportState::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<ExperimentReportError> ERROR_FIELD = SdkField
            .<ExperimentReportError> builder(MarshallingType.SDK_POJO).memberName("error")
            .getter(getter(ExperimentReportState::error)).setter(setter(Builder::error))
            .constructor(ExperimentReportError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASON_FIELD,
            ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String reason;

    private final ExperimentReportError error;

    private ExperimentReportState(BuilderImpl builder) {
        this.status = builder.status;
        this.reason = builder.reason;
        this.error = builder.error;
    }

    /**
     * <p>
     * The state of the experiment report generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperimentReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the experiment report generation.
     * @see ExperimentReportStatus
     */
    public final ExperimentReportStatus status() {
        return ExperimentReportStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the experiment report generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExperimentReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the experiment report generation.
     * @see ExperimentReportStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the state of the experiment report generation.
     * </p>
     * 
     * @return The reason for the state of the experiment report generation.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The error information of the experiment when the experiment report generation has failed.
     * </p>
     * 
     * @return The error information of the experiment when the experiment report generation has failed.
     */
    public final ExperimentReportError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentReportState)) {
            return false;
        }
        ExperimentReportState other = (ExperimentReportState) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(reason(), other.reason())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentReportState").add("Status", statusAsString()).add("Reason", reason())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentReportState, T> g) {
        return obj -> g.apply((ExperimentReportState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentReportState> {
        /**
         * <p>
         * The state of the experiment report generation.
         * </p>
         * 
         * @param status
         *        The state of the experiment report generation.
         * @see ExperimentReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentReportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the experiment report generation.
         * </p>
         * 
         * @param status
         *        The state of the experiment report generation.
         * @see ExperimentReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExperimentReportStatus
         */
        Builder status(ExperimentReportStatus status);

        /**
         * <p>
         * The reason for the state of the experiment report generation.
         * </p>
         * 
         * @param reason
         *        The reason for the state of the experiment report generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The error information of the experiment when the experiment report generation has failed.
         * </p>
         * 
         * @param error
         *        The error information of the experiment when the experiment report generation has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ExperimentReportError error);

        /**
         * <p>
         * The error information of the experiment when the experiment report generation has failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentReportError.Builder} avoiding
         * the need to create one manually via {@link ExperimentReportError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentReportError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(ExperimentReportError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ExperimentReportError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ExperimentReportError)
         */
        default Builder error(Consumer<ExperimentReportError.Builder> error) {
            return error(ExperimentReportError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String reason;

        private ExperimentReportError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentReportState model) {
            status(model.status);
            reason(model.reason);
            error(model.error);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExperimentReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final ExperimentReportError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ExperimentReportError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ExperimentReportError error) {
            this.error = error;
            return this;
        }

        @Override
        public ExperimentReportState build() {
            return new ExperimentReportState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
