/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExperimentStatus {
    PENDING("pending"),
    INITIATING("initiating"),
    RUNNING("running"),
    COMPLETED("completed"),
    STOPPING("stopping"),
    STOPPED("stopped"),
    FAILED("failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExperimentStatus> VALUE_MAP;
    private final String value;

    private ExperimentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExperimentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExperimentStatus> knownValues() {
        EnumSet<ExperimentStatus> knownValues = EnumSet.allOf(ExperimentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExperimentStatus.class, ExperimentStatus::toString);
    }
}

