/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints;
import software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod;
import software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions;
import software.amazon.awssdk.services.firehose.model.ElasticsearchS3BackupMode;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchDestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchDestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::roleARN)).setter(ElasticsearchDestinationConfiguration.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::domainARN)).setter(ElasticsearchDestinationConfiguration.setter(Builder::domainARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainARN").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::indexName)).setter(ElasticsearchDestinationConfiguration.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::typeName)).setter(ElasticsearchDestinationConfiguration.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> INDEX_ROTATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::indexRotationPeriodAsString)).setter(ElasticsearchDestinationConfiguration.setter(Builder::indexRotationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexRotationPeriod").build()}).build();
    private static final SdkField<ElasticsearchBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::bufferingHints)).setter(ElasticsearchDestinationConfiguration.setter(Builder::bufferingHints)).constructor(ElasticsearchBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<ElasticsearchRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::retryOptions)).setter(ElasticsearchDestinationConfiguration.setter(Builder::retryOptions)).constructor(ElasticsearchRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::s3BackupModeAsString)).setter(ElasticsearchDestinationConfiguration.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::s3Configuration)).setter(ElasticsearchDestinationConfiguration.setter(Builder::s3Configuration)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::processingConfiguration)).setter(ElasticsearchDestinationConfiguration.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDestinationConfiguration.getter(ElasticsearchDestinationConfiguration::cloudWatchLoggingOptions)).setter(ElasticsearchDestinationConfiguration.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DOMAIN_ARN_FIELD, INDEX_NAME_FIELD, TYPE_NAME_FIELD, INDEX_ROTATION_PERIOD_FIELD, BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_CONFIGURATION_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String domainARN;
    private final String indexName;
    private final String typeName;
    private final String indexRotationPeriod;
    private final ElasticsearchBufferingHints bufferingHints;
    private final ElasticsearchRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3Configuration;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private ElasticsearchDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String domainARN() {
        return this.domainARN;
    }

    public String indexName() {
        return this.indexName;
    }

    public String typeName() {
        return this.typeName;
    }

    public ElasticsearchIndexRotationPeriod indexRotationPeriod() {
        return ElasticsearchIndexRotationPeriod.fromValue(this.indexRotationPeriod);
    }

    public String indexRotationPeriodAsString() {
        return this.indexRotationPeriod;
    }

    public ElasticsearchBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public ElasticsearchRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public ElasticsearchS3BackupMode s3BackupMode() {
        return ElasticsearchS3BackupMode.fromValue(this.s3BackupMode);
    }

    public String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexRotationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationConfiguration)) {
            return false;
        }
        ElasticsearchDestinationConfiguration other = (ElasticsearchDestinationConfiguration)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.domainARN(), other.domainARN()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.indexRotationPeriodAsString(), other.indexRotationPeriodAsString()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchDestinationConfiguration").add("RoleARN", (Object)this.roleARN()).add("DomainARN", (Object)this.domainARN()).add("IndexName", (Object)this.indexName()).add("TypeName", (Object)this.typeName()).add("IndexRotationPeriod", (Object)this.indexRotationPeriodAsString()).add("BufferingHints", (Object)this.bufferingHints()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3Configuration", (Object)this.s3Configuration()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "DomainARN": {
                return Optional.ofNullable(clazz.cast(this.domainARN()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "IndexRotationPeriod": {
                return Optional.ofNullable(clazz.cast(this.indexRotationPeriodAsString()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDestinationConfiguration, T> g) {
        return obj -> g.apply((ElasticsearchDestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String domainARN;
        private String indexName;
        private String typeName;
        private String indexRotationPeriod;
        private ElasticsearchBufferingHints bufferingHints;
        private ElasticsearchRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationConfiguration s3Configuration;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationConfiguration model) {
            this.roleARN(model.roleARN);
            this.domainARN(model.domainARN);
            this.indexName(model.indexName);
            this.typeName(model.typeName);
            this.indexRotationPeriod(model.indexRotationPeriod);
            this.bufferingHints(model.bufferingHints);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Configuration(model.s3Configuration);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getDomainARN() {
            return this.domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getIndexRotationPeriodAsString() {
            return this.indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod == null ? null : indexRotationPeriod.toString());
            return this;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        public final ElasticsearchBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final ElasticsearchRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final String getS3BackupModeAsString() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public ElasticsearchDestinationConfiguration build() {
            return new ElasticsearchDestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchDestinationConfiguration> {
        public Builder roleARN(String var1);

        public Builder domainARN(String var1);

        public Builder indexName(String var1);

        public Builder typeName(String var1);

        public Builder indexRotationPeriod(String var1);

        public Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod var1);

        public Builder bufferingHints(ElasticsearchBufferingHints var1);

        default public Builder bufferingHints(Consumer<ElasticsearchBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((ElasticsearchBufferingHints)((ElasticsearchBufferingHints.Builder)ElasticsearchBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder retryOptions(ElasticsearchRetryOptions var1);

        default public Builder retryOptions(Consumer<ElasticsearchRetryOptions.Builder> retryOptions) {
            return this.retryOptions((ElasticsearchRetryOptions)((ElasticsearchRetryOptions.Builder)ElasticsearchRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(ElasticsearchS3BackupMode var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }
    }
}

