/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.FirehoseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordResponse
extends FirehoseResponse
implements ToCopyableBuilder<Builder, PutRecordResponse> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordId").getter(PutRecordResponse.getter(PutRecordResponse::recordId)).setter(PutRecordResponse.setter(Builder::recordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(PutRecordResponse.getter(PutRecordResponse::encrypted)).setter(PutRecordResponse.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD, ENCRYPTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRecordResponse.memberNameToFieldInitializer();
    private final String recordId;
    private final Boolean encrypted;

    private PutRecordResponse(BuilderImpl builder) {
        super(builder);
        this.recordId = builder.recordId;
        this.encrypted = builder.encrypted;
    }

    public final String recordId() {
        return this.recordId;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordResponse)) {
            return false;
        }
        PutRecordResponse other = (PutRecordResponse)((Object)obj);
        return Objects.equals(this.recordId(), other.recordId()) && Objects.equals(this.encrypted(), other.encrypted());
    }

    public final String toString() {
        return ToString.builder((String)"PutRecordResponse").add("RecordId", (Object)this.recordId()).add("Encrypted", (Object)this.encrypted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordId": {
                return Optional.ofNullable(clazz.cast(this.recordId()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRecordResponse, T> g) {
        return obj -> g.apply((PutRecordResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseResponse.BuilderImpl
    implements Builder {
        private String recordId;
        private Boolean encrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordResponse model) {
            super(model);
            this.recordId(model.recordId);
            this.encrypted(model.encrypted);
        }

        public final String getRecordId() {
            return this.recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        @Override
        public PutRecordResponse build() {
            return new PutRecordResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FirehoseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordResponse> {
        public Builder recordId(String var1);

        public Builder encrypted(Boolean var1);
    }
}

