/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.firehose.auth.scheme.FirehoseAuthSchemeParams;
import software.amazon.awssdk.services.firehose.auth.scheme.internal.DefaultFirehoseAuthSchemeProvider;
import software.amazon.awssdk.services.firehose.auth.scheme.internal.PreferredFirehoseAuthSchemeProvider;

@SdkPublicApi
public interface FirehoseAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(FirehoseAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<FirehoseAuthSchemeParams.Builder> consumer) {
        FirehoseAuthSchemeParams.Builder builder = FirehoseAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static FirehoseAuthSchemeProvider defaultProvider() {
        return DefaultFirehoseAuthSchemeProvider.create();
    }

    public static FirehoseAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredFirehoseAuthSchemeProvider(FirehoseAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

