/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamNameListCopier;
import software.amazon.awssdk.services.firehose.model.FirehoseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeliveryStreamsResponse
extends FirehoseResponse
implements ToCopyableBuilder<Builder, ListDeliveryStreamsResponse> {
    private static final SdkField<List<String>> DELIVERY_STREAM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeliveryStreamNames").getter(ListDeliveryStreamsResponse.getter(ListDeliveryStreamsResponse::deliveryStreamNames)).setter(ListDeliveryStreamsResponse.setter(Builder::deliveryStreamNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> HAS_MORE_DELIVERY_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasMoreDeliveryStreams").getter(ListDeliveryStreamsResponse.getter(ListDeliveryStreamsResponse::hasMoreDeliveryStreams)).setter(ListDeliveryStreamsResponse.setter(Builder::hasMoreDeliveryStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreDeliveryStreams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAMES_FIELD, HAS_MORE_DELIVERY_STREAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDeliveryStreamsResponse.memberNameToFieldInitializer();
    private final List<String> deliveryStreamNames;
    private final Boolean hasMoreDeliveryStreams;

    private ListDeliveryStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamNames = builder.deliveryStreamNames;
        this.hasMoreDeliveryStreams = builder.hasMoreDeliveryStreams;
    }

    public final boolean hasDeliveryStreamNames() {
        return this.deliveryStreamNames != null && !(this.deliveryStreamNames instanceof SdkAutoConstructList);
    }

    public final List<String> deliveryStreamNames() {
        return this.deliveryStreamNames;
    }

    public final Boolean hasMoreDeliveryStreams() {
        return this.hasMoreDeliveryStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeliveryStreamNames() ? this.deliveryStreamNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreDeliveryStreams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsResponse)) {
            return false;
        }
        ListDeliveryStreamsResponse other = (ListDeliveryStreamsResponse)((Object)obj);
        return this.hasDeliveryStreamNames() == other.hasDeliveryStreamNames() && Objects.equals(this.deliveryStreamNames(), other.deliveryStreamNames()) && Objects.equals(this.hasMoreDeliveryStreams(), other.hasMoreDeliveryStreams());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeliveryStreamsResponse").add("DeliveryStreamNames", this.hasDeliveryStreamNames() ? this.deliveryStreamNames() : null).add("HasMoreDeliveryStreams", (Object)this.hasMoreDeliveryStreams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamNames": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamNames()));
            }
            case "HasMoreDeliveryStreams": {
                return Optional.ofNullable(clazz.cast(this.hasMoreDeliveryStreams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeliveryStreamNames", DELIVERY_STREAM_NAMES_FIELD);
        map.put("HasMoreDeliveryStreams", HAS_MORE_DELIVERY_STREAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeliveryStreamsResponse, T> g) {
        return obj -> g.apply((ListDeliveryStreamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseResponse.BuilderImpl
    implements Builder {
        private List<String> deliveryStreamNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean hasMoreDeliveryStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsResponse model) {
            super(model);
            this.deliveryStreamNames(model.deliveryStreamNames);
            this.hasMoreDeliveryStreams(model.hasMoreDeliveryStreams);
        }

        public final Collection<String> getDeliveryStreamNames() {
            if (this.deliveryStreamNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deliveryStreamNames;
        }

        public final void setDeliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
        }

        @Override
        public final Builder deliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryStreamNames(String ... deliveryStreamNames) {
            this.deliveryStreamNames(Arrays.asList(deliveryStreamNames));
            return this;
        }

        public final Boolean getHasMoreDeliveryStreams() {
            return this.hasMoreDeliveryStreams;
        }

        public final void setHasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
        }

        @Override
        public final Builder hasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
            return this;
        }

        @Override
        public ListDeliveryStreamsResponse build() {
            return new ListDeliveryStreamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FirehoseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeliveryStreamsResponse> {
        public Builder deliveryStreamNames(Collection<String> var1);

        public Builder deliveryStreamNames(String ... var1);

        public Builder hasMoreDeliveryStreams(Boolean var1);
    }
}

