/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.AuthenticationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MSKSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MSKSourceConfiguration> {
    private static final SdkField<String> MSK_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MSKClusterARN").getter(MSKSourceConfiguration.getter(MSKSourceConfiguration::mskClusterARN)).setter(MSKSourceConfiguration.setter(Builder::mskClusterARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MSKClusterARN").build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(MSKSourceConfiguration.getter(MSKSourceConfiguration::topicName)).setter(MSKSourceConfiguration.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfiguration").getter(MSKSourceConfiguration.getter(MSKSourceConfiguration::authenticationConfiguration)).setter(MSKSourceConfiguration.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration").build()}).build();
    private static final SdkField<Instant> READ_FROM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReadFromTimestamp").getter(MSKSourceConfiguration.getter(MSKSourceConfiguration::readFromTimestamp)).setter(MSKSourceConfiguration.setter(Builder::readFromTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadFromTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MSK_CLUSTER_ARN_FIELD, TOPIC_NAME_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, READ_FROM_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mskClusterARN;
    private final String topicName;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final Instant readFromTimestamp;

    private MSKSourceConfiguration(BuilderImpl builder) {
        this.mskClusterARN = builder.mskClusterARN;
        this.topicName = builder.topicName;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.readFromTimestamp = builder.readFromTimestamp;
    }

    public final String mskClusterARN() {
        return this.mskClusterARN;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final AuthenticationConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final Instant readFromTimestamp() {
        return this.readFromTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mskClusterARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.readFromTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MSKSourceConfiguration)) {
            return false;
        }
        MSKSourceConfiguration other = (MSKSourceConfiguration)obj;
        return Objects.equals(this.mskClusterARN(), other.mskClusterARN()) && Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && Objects.equals(this.readFromTimestamp(), other.readFromTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"MSKSourceConfiguration").add("MSKClusterARN", (Object)this.mskClusterARN()).add("TopicName", (Object)this.topicName()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("ReadFromTimestamp", (Object)this.readFromTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MSKClusterARN": {
                return Optional.ofNullable(clazz.cast(this.mskClusterARN()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "AuthenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "ReadFromTimestamp": {
                return Optional.ofNullable(clazz.cast(this.readFromTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MSKSourceConfiguration, T> g) {
        return obj -> g.apply((MSKSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mskClusterARN;
        private String topicName;
        private AuthenticationConfiguration authenticationConfiguration;
        private Instant readFromTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MSKSourceConfiguration model) {
            this.mskClusterARN(model.mskClusterARN);
            this.topicName(model.topicName);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.readFromTimestamp(model.readFromTimestamp);
        }

        public final String getMskClusterARN() {
            return this.mskClusterARN;
        }

        public final void setMskClusterARN(String mskClusterARN) {
            this.mskClusterARN = mskClusterARN;
        }

        @Override
        public final Builder mskClusterARN(String mskClusterARN) {
            this.mskClusterARN = mskClusterARN;
            return this;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Instant getReadFromTimestamp() {
            return this.readFromTimestamp;
        }

        public final void setReadFromTimestamp(Instant readFromTimestamp) {
            this.readFromTimestamp = readFromTimestamp;
        }

        @Override
        public final Builder readFromTimestamp(Instant readFromTimestamp) {
            this.readFromTimestamp = readFromTimestamp;
            return this;
        }

        public MSKSourceConfiguration build() {
            return new MSKSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MSKSourceConfiguration> {
        public Builder mskClusterARN(String var1);

        public Builder topicName(String var1);

        public Builder authenticationConfiguration(AuthenticationConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfiguration)((AuthenticationConfiguration.Builder)AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder readFromTimestamp(Instant var1);
    }
}

