/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.FailureDescription;
import software.amazon.awssdk.services.firehose.model.SnapshotRequestedBy;
import software.amazon.awssdk.services.firehose.model.SnapshotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseSnapshotInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseSnapshotInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DatabaseSnapshotInfo.getter(DatabaseSnapshotInfo::id)).setter(DatabaseSnapshotInfo.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(DatabaseSnapshotInfo.getter(DatabaseSnapshotInfo::table)).setter(DatabaseSnapshotInfo.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<Instant> REQUEST_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestTimestamp").getter(DatabaseSnapshotInfo.getter(DatabaseSnapshotInfo::requestTimestamp)).setter(DatabaseSnapshotInfo.setter(Builder::requestTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTimestamp").build()}).build();
    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestedBy").getter(DatabaseSnapshotInfo.getter(DatabaseSnapshotInfo::requestedByAsString)).setter(DatabaseSnapshotInfo.setter(Builder::requestedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DatabaseSnapshotInfo.getter(DatabaseSnapshotInfo::statusAsString)).setter(DatabaseSnapshotInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<FailureDescription> FAILURE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDescription").getter(DatabaseSnapshotInfo.getter(DatabaseSnapshotInfo::failureDescription)).setter(DatabaseSnapshotInfo.setter(Builder::failureDescription)).constructor(FailureDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TABLE_FIELD, REQUEST_TIMESTAMP_FIELD, REQUESTED_BY_FIELD, STATUS_FIELD, FAILURE_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Table", TABLE_FIELD);
            this.put("RequestTimestamp", REQUEST_TIMESTAMP_FIELD);
            this.put("RequestedBy", REQUESTED_BY_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("FailureDescription", FAILURE_DESCRIPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String table;
    private final Instant requestTimestamp;
    private final String requestedBy;
    private final String status;
    private final FailureDescription failureDescription;

    private DatabaseSnapshotInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.table = builder.table;
        this.requestTimestamp = builder.requestTimestamp;
        this.requestedBy = builder.requestedBy;
        this.status = builder.status;
        this.failureDescription = builder.failureDescription;
    }

    public final String id() {
        return this.id;
    }

    public final String table() {
        return this.table;
    }

    public final Instant requestTimestamp() {
        return this.requestTimestamp;
    }

    public final SnapshotRequestedBy requestedBy() {
        return SnapshotRequestedBy.fromValue(this.requestedBy);
    }

    public final String requestedByAsString() {
        return this.requestedBy;
    }

    public final SnapshotStatus status() {
        return SnapshotStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final FailureDescription failureDescription() {
        return this.failureDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseSnapshotInfo)) {
            return false;
        }
        DatabaseSnapshotInfo other = (DatabaseSnapshotInfo)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.requestTimestamp(), other.requestTimestamp()) && Objects.equals(this.requestedByAsString(), other.requestedByAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureDescription(), other.failureDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DatabaseSnapshotInfo").add("Id", (Object)this.id()).add("Table", (Object)this.table()).add("RequestTimestamp", (Object)this.requestTimestamp()).add("RequestedBy", (Object)this.requestedByAsString()).add("Status", (Object)this.statusAsString()).add("FailureDescription", (Object)this.failureDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "RequestTimestamp": {
                return Optional.ofNullable(clazz.cast(this.requestTimestamp()));
            }
            case "RequestedBy": {
                return Optional.ofNullable(clazz.cast(this.requestedByAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureDescription": {
                return Optional.ofNullable(clazz.cast(this.failureDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseSnapshotInfo, T> g) {
        return obj -> g.apply((DatabaseSnapshotInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String table;
        private Instant requestTimestamp;
        private String requestedBy;
        private String status;
        private FailureDescription failureDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseSnapshotInfo model) {
            this.id(model.id);
            this.table(model.table);
            this.requestTimestamp(model.requestTimestamp);
            this.requestedBy(model.requestedBy);
            this.status(model.status);
            this.failureDescription(model.failureDescription);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final Instant getRequestTimestamp() {
            return this.requestTimestamp;
        }

        public final void setRequestTimestamp(Instant requestTimestamp) {
            this.requestTimestamp = requestTimestamp;
        }

        @Override
        public final Builder requestTimestamp(Instant requestTimestamp) {
            this.requestTimestamp = requestTimestamp;
            return this;
        }

        public final String getRequestedBy() {
            return this.requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        @Override
        public final Builder requestedBy(SnapshotRequestedBy requestedBy) {
            this.requestedBy(requestedBy == null ? null : requestedBy.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final FailureDescription.Builder getFailureDescription() {
            return this.failureDescription != null ? this.failureDescription.toBuilder() : null;
        }

        public final void setFailureDescription(FailureDescription.BuilderImpl failureDescription) {
            this.failureDescription = failureDescription != null ? failureDescription.build() : null;
        }

        @Override
        public final Builder failureDescription(FailureDescription failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        public DatabaseSnapshotInfo build() {
            return new DatabaseSnapshotInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseSnapshotInfo> {
        public Builder id(String var1);

        public Builder table(String var1);

        public Builder requestTimestamp(Instant var1);

        public Builder requestedBy(String var1);

        public Builder requestedBy(SnapshotRequestedBy var1);

        public Builder status(String var1);

        public Builder status(SnapshotStatus var1);

        public Builder failureDescription(FailureDescription var1);

        default public Builder failureDescription(Consumer<FailureDescription.Builder> failureDescription) {
            return this.failureDescription((FailureDescription)((FailureDescription.Builder)FailureDescription.builder().applyMutation(failureDescription)).build());
        }
    }
}

