/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeliveryStreamType {
    DIRECT_PUT("DirectPut"),
    KINESIS_STREAM_AS_SOURCE("KinesisStreamAsSource"),
    MSK_AS_SOURCE("MSKAsSource"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryStreamType> VALUE_MAP;
    private final String value;

    private DeliveryStreamType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryStreamType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryStreamType> knownValues() {
        EnumSet<DeliveryStreamType> knownValues = EnumSet.allOf(DeliveryStreamType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeliveryStreamType.class, DeliveryStreamType::toString);
    }
}

