/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.DocumentIdOptions;
import software.amazon.awssdk.services.firehose.model.ElasticsearchBufferingHints;
import software.amazon.awssdk.services.firehose.model.ElasticsearchIndexRotationPeriod;
import software.amazon.awssdk.services.firehose.model.ElasticsearchRetryOptions;
import software.amazon.awssdk.services.firehose.model.ElasticsearchS3BackupMode;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.services.firehose.model.VpcConfigurationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchDestinationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchDestinationDescription> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::roleARN)).setter(ElasticsearchDestinationDescription.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainARN").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::domainARN)).setter(ElasticsearchDestinationDescription.setter(Builder::domainARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainARN").build()}).build();
    private static final SdkField<String> CLUSTER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterEndpoint").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::clusterEndpoint)).setter(ElasticsearchDestinationDescription.setter(Builder::clusterEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoint").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::indexName)).setter(ElasticsearchDestinationDescription.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::typeName)).setter(ElasticsearchDestinationDescription.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> INDEX_ROTATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexRotationPeriod").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::indexRotationPeriodAsString)).setter(ElasticsearchDestinationDescription.setter(Builder::indexRotationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexRotationPeriod").build()}).build();
    private static final SdkField<ElasticsearchBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::bufferingHints)).setter(ElasticsearchDestinationDescription.setter(Builder::bufferingHints)).constructor(ElasticsearchBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<ElasticsearchRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::retryOptions)).setter(ElasticsearchDestinationDescription.setter(Builder::retryOptions)).constructor(ElasticsearchRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::s3BackupModeAsString)).setter(ElasticsearchDestinationDescription.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationDescription> S3_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DestinationDescription").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::s3DestinationDescription)).setter(ElasticsearchDestinationDescription.setter(Builder::s3DestinationDescription)).constructor(S3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationDescription").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::processingConfiguration)).setter(ElasticsearchDestinationDescription.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::cloudWatchLoggingOptions)).setter(ElasticsearchDestinationDescription.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<VpcConfigurationDescription> VPC_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfigurationDescription").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::vpcConfigurationDescription)).setter(ElasticsearchDestinationDescription.setter(Builder::vpcConfigurationDescription)).constructor(VpcConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationDescription").build()}).build();
    private static final SdkField<DocumentIdOptions> DOCUMENT_ID_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentIdOptions").getter(ElasticsearchDestinationDescription.getter(ElasticsearchDestinationDescription::documentIdOptions)).setter(ElasticsearchDestinationDescription.setter(Builder::documentIdOptions)).constructor(DocumentIdOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIdOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DOMAIN_ARN_FIELD, CLUSTER_ENDPOINT_FIELD, INDEX_NAME_FIELD, TYPE_NAME_FIELD, INDEX_ROTATION_PERIOD_FIELD, BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_DESTINATION_DESCRIPTION_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, VPC_CONFIGURATION_DESCRIPTION_FIELD, DOCUMENT_ID_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String domainARN;
    private final String clusterEndpoint;
    private final String indexName;
    private final String typeName;
    private final String indexRotationPeriod;
    private final ElasticsearchBufferingHints bufferingHints;
    private final ElasticsearchRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationDescription s3DestinationDescription;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final VpcConfigurationDescription vpcConfigurationDescription;
    private final DocumentIdOptions documentIdOptions;

    private ElasticsearchDestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.vpcConfigurationDescription = builder.vpcConfigurationDescription;
        this.documentIdOptions = builder.documentIdOptions;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String domainARN() {
        return this.domainARN;
    }

    public final String clusterEndpoint() {
        return this.clusterEndpoint;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final ElasticsearchIndexRotationPeriod indexRotationPeriod() {
        return ElasticsearchIndexRotationPeriod.fromValue(this.indexRotationPeriod);
    }

    public final String indexRotationPeriodAsString() {
        return this.indexRotationPeriod;
    }

    public final ElasticsearchBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final ElasticsearchRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final ElasticsearchS3BackupMode s3BackupMode() {
        return ElasticsearchS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final VpcConfigurationDescription vpcConfigurationDescription() {
        return this.vpcConfigurationDescription;
    }

    public final DocumentIdOptions documentIdOptions() {
        return this.documentIdOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexRotationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationDescription)) {
            return false;
        }
        ElasticsearchDestinationDescription other = (ElasticsearchDestinationDescription)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.domainARN(), other.domainARN()) && Objects.equals(this.clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.indexRotationPeriodAsString(), other.indexRotationPeriodAsString()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3DestinationDescription(), other.s3DestinationDescription()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.vpcConfigurationDescription(), other.vpcConfigurationDescription()) && Objects.equals(this.documentIdOptions(), other.documentIdOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ElasticsearchDestinationDescription").add("RoleARN", (Object)this.roleARN()).add("DomainARN", (Object)this.domainARN()).add("ClusterEndpoint", (Object)this.clusterEndpoint()).add("IndexName", (Object)this.indexName()).add("TypeName", (Object)this.typeName()).add("IndexRotationPeriod", (Object)this.indexRotationPeriodAsString()).add("BufferingHints", (Object)this.bufferingHints()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3DestinationDescription", (Object)this.s3DestinationDescription()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("VpcConfigurationDescription", (Object)this.vpcConfigurationDescription()).add("DocumentIdOptions", (Object)this.documentIdOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "DomainARN": {
                return Optional.ofNullable(clazz.cast(this.domainARN()));
            }
            case "ClusterEndpoint": {
                return Optional.ofNullable(clazz.cast(this.clusterEndpoint()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "IndexRotationPeriod": {
                return Optional.ofNullable(clazz.cast(this.indexRotationPeriodAsString()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationDescription()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "VpcConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.vpcConfigurationDescription()));
            }
            case "DocumentIdOptions": {
                return Optional.ofNullable(clazz.cast(this.documentIdOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDestinationDescription, T> g) {
        return obj -> g.apply((ElasticsearchDestinationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String domainARN;
        private String clusterEndpoint;
        private String indexName;
        private String typeName;
        private String indexRotationPeriod;
        private ElasticsearchBufferingHints bufferingHints;
        private ElasticsearchRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationDescription s3DestinationDescription;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private VpcConfigurationDescription vpcConfigurationDescription;
        private DocumentIdOptions documentIdOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationDescription model) {
            this.roleARN(model.roleARN);
            this.domainARN(model.domainARN);
            this.clusterEndpoint(model.clusterEndpoint);
            this.indexName(model.indexName);
            this.typeName(model.typeName);
            this.indexRotationPeriod(model.indexRotationPeriod);
            this.bufferingHints(model.bufferingHints);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3DestinationDescription(model.s3DestinationDescription);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.vpcConfigurationDescription(model.vpcConfigurationDescription);
            this.documentIdOptions(model.documentIdOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getDomainARN() {
            return this.domainARN;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final String getClusterEndpoint() {
            return this.clusterEndpoint;
        }

        public final void setClusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
        }

        @Override
        public final Builder clusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getIndexRotationPeriod() {
            return this.indexRotationPeriod;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod == null ? null : indexRotationPeriod.toString());
            return this;
        }

        public final ElasticsearchBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final ElasticsearchRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return this.s3DestinationDescription != null ? this.s3DestinationDescription.toBuilder() : null;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final VpcConfigurationDescription.Builder getVpcConfigurationDescription() {
            return this.vpcConfigurationDescription != null ? this.vpcConfigurationDescription.toBuilder() : null;
        }

        public final void setVpcConfigurationDescription(VpcConfigurationDescription.BuilderImpl vpcConfigurationDescription) {
            this.vpcConfigurationDescription = vpcConfigurationDescription != null ? vpcConfigurationDescription.build() : null;
        }

        @Override
        public final Builder vpcConfigurationDescription(VpcConfigurationDescription vpcConfigurationDescription) {
            this.vpcConfigurationDescription = vpcConfigurationDescription;
            return this;
        }

        public final DocumentIdOptions.Builder getDocumentIdOptions() {
            return this.documentIdOptions != null ? this.documentIdOptions.toBuilder() : null;
        }

        public final void setDocumentIdOptions(DocumentIdOptions.BuilderImpl documentIdOptions) {
            this.documentIdOptions = documentIdOptions != null ? documentIdOptions.build() : null;
        }

        @Override
        public final Builder documentIdOptions(DocumentIdOptions documentIdOptions) {
            this.documentIdOptions = documentIdOptions;
            return this;
        }

        public ElasticsearchDestinationDescription build() {
            return new ElasticsearchDestinationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchDestinationDescription> {
        public Builder roleARN(String var1);

        public Builder domainARN(String var1);

        public Builder clusterEndpoint(String var1);

        public Builder indexName(String var1);

        public Builder typeName(String var1);

        public Builder indexRotationPeriod(String var1);

        public Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod var1);

        public Builder bufferingHints(ElasticsearchBufferingHints var1);

        default public Builder bufferingHints(Consumer<ElasticsearchBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((ElasticsearchBufferingHints)((ElasticsearchBufferingHints.Builder)ElasticsearchBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder retryOptions(ElasticsearchRetryOptions var1);

        default public Builder retryOptions(Consumer<ElasticsearchRetryOptions.Builder> retryOptions) {
            return this.retryOptions((ElasticsearchRetryOptions)((ElasticsearchRetryOptions.Builder)ElasticsearchRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(ElasticsearchS3BackupMode var1);

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        default public Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return this.s3DestinationDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3DestinationDescription)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder vpcConfigurationDescription(VpcConfigurationDescription var1);

        default public Builder vpcConfigurationDescription(Consumer<VpcConfigurationDescription.Builder> vpcConfigurationDescription) {
            return this.vpcConfigurationDescription((VpcConfigurationDescription)((VpcConfigurationDescription.Builder)VpcConfigurationDescription.builder().applyMutation(vpcConfigurationDescription)).build());
        }

        public Builder documentIdOptions(DocumentIdOptions var1);

        default public Builder documentIdOptions(Consumer<DocumentIdOptions.Builder> documentIdOptions) {
            return this.documentIdOptions((DocumentIdOptions)((DocumentIdOptions.Builder)DocumentIdOptions.builder().applyMutation(documentIdOptions)).build());
        }
    }
}

