/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.services.firehose.model.SnowflakeDataLoadingOption;
import software.amazon.awssdk.services.firehose.model.SnowflakeRetryOptions;
import software.amazon.awssdk.services.firehose.model.SnowflakeRoleConfiguration;
import software.amazon.awssdk.services.firehose.model.SnowflakeS3BackupMode;
import software.amazon.awssdk.services.firehose.model.SnowflakeVpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeDestinationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeDestinationDescription> {
    private static final SdkField<String> ACCOUNT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountUrl").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::accountUrl)).setter(SnowflakeDestinationDescription.setter(Builder::accountUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountUrl").build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::user)).setter(SnowflakeDestinationDescription.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::database)).setter(SnowflakeDestinationDescription.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::schema)).setter(SnowflakeDestinationDescription.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::table)).setter(SnowflakeDestinationDescription.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<SnowflakeRoleConfiguration> SNOWFLAKE_ROLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnowflakeRoleConfiguration").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::snowflakeRoleConfiguration)).setter(SnowflakeDestinationDescription.setter(Builder::snowflakeRoleConfiguration)).constructor(SnowflakeRoleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeRoleConfiguration").build()}).build();
    private static final SdkField<String> DATA_LOADING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataLoadingOption").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::dataLoadingOptionAsString)).setter(SnowflakeDestinationDescription.setter(Builder::dataLoadingOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLoadingOption").build()}).build();
    private static final SdkField<String> META_DATA_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetaDataColumnName").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::metaDataColumnName)).setter(SnowflakeDestinationDescription.setter(Builder::metaDataColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaDataColumnName").build()}).build();
    private static final SdkField<String> CONTENT_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentColumnName").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::contentColumnName)).setter(SnowflakeDestinationDescription.setter(Builder::contentColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentColumnName").build()}).build();
    private static final SdkField<SnowflakeVpcConfiguration> SNOWFLAKE_VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnowflakeVpcConfiguration").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::snowflakeVpcConfiguration)).setter(SnowflakeDestinationDescription.setter(Builder::snowflakeVpcConfiguration)).constructor(SnowflakeVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeVpcConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::cloudWatchLoggingOptions)).setter(SnowflakeDestinationDescription.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::processingConfiguration)).setter(SnowflakeDestinationDescription.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::roleARN)).setter(SnowflakeDestinationDescription.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<SnowflakeRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::retryOptions)).setter(SnowflakeDestinationDescription.setter(Builder::retryOptions)).constructor(SnowflakeRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::s3BackupModeAsString)).setter(SnowflakeDestinationDescription.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationDescription> S3_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DestinationDescription").getter(SnowflakeDestinationDescription.getter(SnowflakeDestinationDescription::s3DestinationDescription)).setter(SnowflakeDestinationDescription.setter(Builder::s3DestinationDescription)).constructor(S3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_URL_FIELD, USER_FIELD, DATABASE_FIELD, SCHEMA_FIELD, TABLE_FIELD, SNOWFLAKE_ROLE_CONFIGURATION_FIELD, DATA_LOADING_OPTION_FIELD, META_DATA_COLUMN_NAME_FIELD, CONTENT_COLUMN_NAME_FIELD, SNOWFLAKE_VPC_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD, ROLE_ARN_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_DESTINATION_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountUrl;
    private final String user;
    private final String database;
    private final String schema;
    private final String table;
    private final SnowflakeRoleConfiguration snowflakeRoleConfiguration;
    private final String dataLoadingOption;
    private final String metaDataColumnName;
    private final String contentColumnName;
    private final SnowflakeVpcConfiguration snowflakeVpcConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String roleARN;
    private final SnowflakeRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationDescription s3DestinationDescription;

    private SnowflakeDestinationDescription(BuilderImpl builder) {
        this.accountUrl = builder.accountUrl;
        this.user = builder.user;
        this.database = builder.database;
        this.schema = builder.schema;
        this.table = builder.table;
        this.snowflakeRoleConfiguration = builder.snowflakeRoleConfiguration;
        this.dataLoadingOption = builder.dataLoadingOption;
        this.metaDataColumnName = builder.metaDataColumnName;
        this.contentColumnName = builder.contentColumnName;
        this.snowflakeVpcConfiguration = builder.snowflakeVpcConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.roleARN = builder.roleARN;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3DestinationDescription = builder.s3DestinationDescription;
    }

    public final String accountUrl() {
        return this.accountUrl;
    }

    public final String user() {
        return this.user;
    }

    public final String database() {
        return this.database;
    }

    public final String schema() {
        return this.schema;
    }

    public final String table() {
        return this.table;
    }

    public final SnowflakeRoleConfiguration snowflakeRoleConfiguration() {
        return this.snowflakeRoleConfiguration;
    }

    public final SnowflakeDataLoadingOption dataLoadingOption() {
        return SnowflakeDataLoadingOption.fromValue(this.dataLoadingOption);
    }

    public final String dataLoadingOptionAsString() {
        return this.dataLoadingOption;
    }

    public final String metaDataColumnName() {
        return this.metaDataColumnName;
    }

    public final String contentColumnName() {
        return this.contentColumnName;
    }

    public final SnowflakeVpcConfiguration snowflakeVpcConfiguration() {
        return this.snowflakeVpcConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final SnowflakeRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final SnowflakeS3BackupMode s3BackupMode() {
        return SnowflakeS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowflakeRoleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLoadingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metaDataColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowflakeVpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeDestinationDescription)) {
            return false;
        }
        SnowflakeDestinationDescription other = (SnowflakeDestinationDescription)obj;
        return Objects.equals(this.accountUrl(), other.accountUrl()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.snowflakeRoleConfiguration(), other.snowflakeRoleConfiguration()) && Objects.equals(this.dataLoadingOptionAsString(), other.dataLoadingOptionAsString()) && Objects.equals(this.metaDataColumnName(), other.metaDataColumnName()) && Objects.equals(this.contentColumnName(), other.contentColumnName()) && Objects.equals(this.snowflakeVpcConfiguration(), other.snowflakeVpcConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3DestinationDescription(), other.s3DestinationDescription());
    }

    public final String toString() {
        return ToString.builder((String)"SnowflakeDestinationDescription").add("AccountUrl", (Object)(this.accountUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("User", (Object)(this.user() == null ? null : "*** Sensitive Data Redacted ***")).add("Database", (Object)(this.database() == null ? null : "*** Sensitive Data Redacted ***")).add("Schema", (Object)(this.schema() == null ? null : "*** Sensitive Data Redacted ***")).add("Table", (Object)(this.table() == null ? null : "*** Sensitive Data Redacted ***")).add("SnowflakeRoleConfiguration", (Object)this.snowflakeRoleConfiguration()).add("DataLoadingOption", (Object)this.dataLoadingOptionAsString()).add("MetaDataColumnName", (Object)(this.metaDataColumnName() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentColumnName", (Object)(this.contentColumnName() == null ? null : "*** Sensitive Data Redacted ***")).add("SnowflakeVpcConfiguration", (Object)this.snowflakeVpcConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("RoleARN", (Object)this.roleARN()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3DestinationDescription", (Object)this.s3DestinationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountUrl": {
                return Optional.ofNullable(clazz.cast(this.accountUrl()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "SnowflakeRoleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snowflakeRoleConfiguration()));
            }
            case "DataLoadingOption": {
                return Optional.ofNullable(clazz.cast(this.dataLoadingOptionAsString()));
            }
            case "MetaDataColumnName": {
                return Optional.ofNullable(clazz.cast(this.metaDataColumnName()));
            }
            case "ContentColumnName": {
                return Optional.ofNullable(clazz.cast(this.contentColumnName()));
            }
            case "SnowflakeVpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snowflakeVpcConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeDestinationDescription, T> g) {
        return obj -> g.apply((SnowflakeDestinationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountUrl;
        private String user;
        private String database;
        private String schema;
        private String table;
        private SnowflakeRoleConfiguration snowflakeRoleConfiguration;
        private String dataLoadingOption;
        private String metaDataColumnName;
        private String contentColumnName;
        private SnowflakeVpcConfiguration snowflakeVpcConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String roleARN;
        private SnowflakeRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationDescription s3DestinationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeDestinationDescription model) {
            this.accountUrl(model.accountUrl);
            this.user(model.user);
            this.database(model.database);
            this.schema(model.schema);
            this.table(model.table);
            this.snowflakeRoleConfiguration(model.snowflakeRoleConfiguration);
            this.dataLoadingOption(model.dataLoadingOption);
            this.metaDataColumnName(model.metaDataColumnName);
            this.contentColumnName(model.contentColumnName);
            this.snowflakeVpcConfiguration(model.snowflakeVpcConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.processingConfiguration(model.processingConfiguration);
            this.roleARN(model.roleARN);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3DestinationDescription(model.s3DestinationDescription);
        }

        public final String getAccountUrl() {
            return this.accountUrl;
        }

        public final void setAccountUrl(String accountUrl) {
            this.accountUrl = accountUrl;
        }

        @Override
        public final Builder accountUrl(String accountUrl) {
            this.accountUrl = accountUrl;
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final SnowflakeRoleConfiguration.Builder getSnowflakeRoleConfiguration() {
            return this.snowflakeRoleConfiguration != null ? this.snowflakeRoleConfiguration.toBuilder() : null;
        }

        public final void setSnowflakeRoleConfiguration(SnowflakeRoleConfiguration.BuilderImpl snowflakeRoleConfiguration) {
            this.snowflakeRoleConfiguration = snowflakeRoleConfiguration != null ? snowflakeRoleConfiguration.build() : null;
        }

        @Override
        public final Builder snowflakeRoleConfiguration(SnowflakeRoleConfiguration snowflakeRoleConfiguration) {
            this.snowflakeRoleConfiguration = snowflakeRoleConfiguration;
            return this;
        }

        public final String getDataLoadingOption() {
            return this.dataLoadingOption;
        }

        public final void setDataLoadingOption(String dataLoadingOption) {
            this.dataLoadingOption = dataLoadingOption;
        }

        @Override
        public final Builder dataLoadingOption(String dataLoadingOption) {
            this.dataLoadingOption = dataLoadingOption;
            return this;
        }

        @Override
        public final Builder dataLoadingOption(SnowflakeDataLoadingOption dataLoadingOption) {
            this.dataLoadingOption(dataLoadingOption == null ? null : dataLoadingOption.toString());
            return this;
        }

        public final String getMetaDataColumnName() {
            return this.metaDataColumnName;
        }

        public final void setMetaDataColumnName(String metaDataColumnName) {
            this.metaDataColumnName = metaDataColumnName;
        }

        @Override
        public final Builder metaDataColumnName(String metaDataColumnName) {
            this.metaDataColumnName = metaDataColumnName;
            return this;
        }

        public final String getContentColumnName() {
            return this.contentColumnName;
        }

        public final void setContentColumnName(String contentColumnName) {
            this.contentColumnName = contentColumnName;
        }

        @Override
        public final Builder contentColumnName(String contentColumnName) {
            this.contentColumnName = contentColumnName;
            return this;
        }

        public final SnowflakeVpcConfiguration.Builder getSnowflakeVpcConfiguration() {
            return this.snowflakeVpcConfiguration != null ? this.snowflakeVpcConfiguration.toBuilder() : null;
        }

        public final void setSnowflakeVpcConfiguration(SnowflakeVpcConfiguration.BuilderImpl snowflakeVpcConfiguration) {
            this.snowflakeVpcConfiguration = snowflakeVpcConfiguration != null ? snowflakeVpcConfiguration.build() : null;
        }

        @Override
        public final Builder snowflakeVpcConfiguration(SnowflakeVpcConfiguration snowflakeVpcConfiguration) {
            this.snowflakeVpcConfiguration = snowflakeVpcConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final SnowflakeRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(SnowflakeRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(SnowflakeRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(SnowflakeS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return this.s3DestinationDescription != null ? this.s3DestinationDescription.toBuilder() : null;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public SnowflakeDestinationDescription build() {
            return new SnowflakeDestinationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeDestinationDescription> {
        public Builder accountUrl(String var1);

        public Builder user(String var1);

        public Builder database(String var1);

        public Builder schema(String var1);

        public Builder table(String var1);

        public Builder snowflakeRoleConfiguration(SnowflakeRoleConfiguration var1);

        default public Builder snowflakeRoleConfiguration(Consumer<SnowflakeRoleConfiguration.Builder> snowflakeRoleConfiguration) {
            return this.snowflakeRoleConfiguration((SnowflakeRoleConfiguration)((SnowflakeRoleConfiguration.Builder)SnowflakeRoleConfiguration.builder().applyMutation(snowflakeRoleConfiguration)).build());
        }

        public Builder dataLoadingOption(String var1);

        public Builder dataLoadingOption(SnowflakeDataLoadingOption var1);

        public Builder metaDataColumnName(String var1);

        public Builder contentColumnName(String var1);

        public Builder snowflakeVpcConfiguration(SnowflakeVpcConfiguration var1);

        default public Builder snowflakeVpcConfiguration(Consumer<SnowflakeVpcConfiguration.Builder> snowflakeVpcConfiguration) {
            return this.snowflakeVpcConfiguration((SnowflakeVpcConfiguration)((SnowflakeVpcConfiguration.Builder)SnowflakeVpcConfiguration.builder().applyMutation(snowflakeVpcConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder roleARN(String var1);

        public Builder retryOptions(SnowflakeRetryOptions var1);

        default public Builder retryOptions(Consumer<SnowflakeRetryOptions.Builder> retryOptions) {
            return this.retryOptions((SnowflakeRetryOptions)((SnowflakeRetryOptions.Builder)SnowflakeRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(SnowflakeS3BackupMode var1);

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        default public Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return this.s3DestinationDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3DestinationDescription)).build());
        }
    }
}

