/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProcessorParameterName {
    LAMBDA_ARN("LambdaArn"),
    NUMBER_OF_RETRIES("NumberOfRetries"),
    METADATA_EXTRACTION_QUERY("MetadataExtractionQuery"),
    JSON_PARSING_ENGINE("JsonParsingEngine"),
    ROLE_ARN("RoleArn"),
    BUFFER_SIZE_IN_M_BS("BufferSizeInMBs"),
    BUFFER_INTERVAL_IN_SECONDS("BufferIntervalInSeconds"),
    SUB_RECORD_TYPE("SubRecordType"),
    DELIMITER("Delimiter"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProcessorParameterName> VALUE_MAP;
    private final String value;

    private ProcessorParameterName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProcessorParameterName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProcessorParameterName> knownValues() {
        EnumSet<ProcessorParameterName> knownValues = EnumSet.allOf(ProcessorParameterName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProcessorParameterName.class, ProcessorParameterName::toString);
    }
}

