/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CopyCommand;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions;
import software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftDestinationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftDestinationDescription> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::roleARN)).setter(RedshiftDestinationDescription.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> CLUSTER_JDBCURL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::clusterJDBCURL)).setter(RedshiftDestinationDescription.setter(Builder::clusterJDBCURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterJDBCURL").build()}).build();
    private static final SdkField<CopyCommand> COPY_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::copyCommand)).setter(RedshiftDestinationDescription.setter(Builder::copyCommand)).constructor(CopyCommand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyCommand").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::username)).setter(RedshiftDestinationDescription.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<RedshiftRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::retryOptions)).setter(RedshiftDestinationDescription.setter(Builder::retryOptions)).constructor(RedshiftRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<S3DestinationDescription> S3_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::s3DestinationDescription)).setter(RedshiftDestinationDescription.setter(Builder::s3DestinationDescription)).constructor(S3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationDescription").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::processingConfiguration)).setter(RedshiftDestinationDescription.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::s3BackupModeAsString)).setter(RedshiftDestinationDescription.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationDescription> S3_BACKUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::s3BackupDescription)).setter(RedshiftDestinationDescription.setter(Builder::s3BackupDescription)).constructor(S3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupDescription").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RedshiftDestinationDescription.getter(RedshiftDestinationDescription::cloudWatchLoggingOptions)).setter(RedshiftDestinationDescription.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, CLUSTER_JDBCURL_FIELD, COPY_COMMAND_FIELD, USERNAME_FIELD, RETRY_OPTIONS_FIELD, S3_DESTINATION_DESCRIPTION_FIELD, PROCESSING_CONFIGURATION_FIELD, S3_BACKUP_MODE_FIELD, S3_BACKUP_DESCRIPTION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String clusterJDBCURL;
    private final CopyCommand copyCommand;
    private final String username;
    private final RedshiftRetryOptions retryOptions;
    private final S3DestinationDescription s3DestinationDescription;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationDescription s3BackupDescription;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private RedshiftDestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.clusterJDBCURL = builder.clusterJDBCURL;
        this.copyCommand = builder.copyCommand;
        this.username = builder.username;
        this.retryOptions = builder.retryOptions;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupDescription = builder.s3BackupDescription;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String clusterJDBCURL() {
        return this.clusterJDBCURL;
    }

    public CopyCommand copyCommand() {
        return this.copyCommand;
    }

    public String username() {
        return this.username;
    }

    public RedshiftRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public RedshiftS3BackupMode s3BackupMode() {
        return RedshiftS3BackupMode.fromValue(this.s3BackupMode);
    }

    public String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public S3DestinationDescription s3BackupDescription() {
        return this.s3BackupDescription;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterJDBCURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDestinationDescription)) {
            return false;
        }
        RedshiftDestinationDescription other = (RedshiftDestinationDescription)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.clusterJDBCURL(), other.clusterJDBCURL()) && Objects.equals(this.copyCommand(), other.copyCommand()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3DestinationDescription(), other.s3DestinationDescription()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3BackupDescription(), other.s3BackupDescription()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    public String toString() {
        return ToString.builder((String)"RedshiftDestinationDescription").add("RoleARN", (Object)this.roleARN()).add("ClusterJDBCURL", (Object)this.clusterJDBCURL()).add("CopyCommand", (Object)this.copyCommand()).add("Username", (Object)this.username()).add("RetryOptions", (Object)this.retryOptions()).add("S3DestinationDescription", (Object)this.s3DestinationDescription()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3BackupDescription", (Object)this.s3BackupDescription()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "ClusterJDBCURL": {
                return Optional.ofNullable(clazz.cast(this.clusterJDBCURL()));
            }
            case "CopyCommand": {
                return Optional.ofNullable(clazz.cast(this.copyCommand()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationDescription()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3BackupDescription": {
                return Optional.ofNullable(clazz.cast(this.s3BackupDescription()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDestinationDescription, T> g) {
        return obj -> g.apply((RedshiftDestinationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String clusterJDBCURL;
        private CopyCommand copyCommand;
        private String username;
        private RedshiftRetryOptions retryOptions;
        private S3DestinationDescription s3DestinationDescription;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationDescription s3BackupDescription;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDestinationDescription model) {
            this.roleARN(model.roleARN);
            this.clusterJDBCURL(model.clusterJDBCURL);
            this.copyCommand(model.copyCommand);
            this.username(model.username);
            this.retryOptions(model.retryOptions);
            this.s3DestinationDescription(model.s3DestinationDescription);
            this.processingConfiguration(model.processingConfiguration);
            this.s3BackupMode(model.s3BackupMode);
            this.s3BackupDescription(model.s3BackupDescription);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterJDBCURL() {
            return this.clusterJDBCURL;
        }

        @Override
        public final Builder clusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
            return this;
        }

        public final void setClusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
        }

        public final CopyCommand.Builder getCopyCommand() {
            return this.copyCommand != null ? this.copyCommand.toBuilder() : null;
        }

        @Override
        public final Builder copyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
            return this;
        }

        public final void setCopyCommand(CopyCommand.BuilderImpl copyCommand) {
            this.copyCommand = copyCommand != null ? copyCommand.build() : null;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final RedshiftRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(RedshiftRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return this.s3DestinationDescription != null ? this.s3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationDescription.Builder getS3BackupDescription() {
            return this.s3BackupDescription != null ? this.s3BackupDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3BackupDescription(S3DestinationDescription s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription;
            return this;
        }

        public final void setS3BackupDescription(S3DestinationDescription.BuilderImpl s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription != null ? s3BackupDescription.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public RedshiftDestinationDescription build() {
            return new RedshiftDestinationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftDestinationDescription> {
        public Builder roleARN(String var1);

        public Builder clusterJDBCURL(String var1);

        public Builder copyCommand(CopyCommand var1);

        default public Builder copyCommand(Consumer<CopyCommand.Builder> copyCommand) {
            return this.copyCommand((CopyCommand)((CopyCommand.Builder)CopyCommand.builder().applyMutation(copyCommand)).build());
        }

        public Builder username(String var1);

        public Builder retryOptions(RedshiftRetryOptions var1);

        default public Builder retryOptions(Consumer<RedshiftRetryOptions.Builder> retryOptions) {
            return this.retryOptions((RedshiftRetryOptions)((RedshiftRetryOptions.Builder)RedshiftRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        default public Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return this.s3DestinationDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3DestinationDescription)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(RedshiftS3BackupMode var1);

        public Builder s3BackupDescription(S3DestinationDescription var1);

        default public Builder s3BackupDescription(Consumer<S3DestinationDescription.Builder> s3BackupDescription) {
            return this.s3BackupDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3BackupDescription)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }
    }
}

