/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyCommand
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CopyCommand> {
    private static final SdkField<String> DATA_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableName").getter(CopyCommand.getter(CopyCommand::dataTableName)).setter(CopyCommand.setter(Builder::dataTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableName").build()}).build();
    private static final SdkField<String> DATA_TABLE_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableColumns").getter(CopyCommand.getter(CopyCommand::dataTableColumns)).setter(CopyCommand.setter(Builder::dataTableColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableColumns").build()}).build();
    private static final SdkField<String> COPY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CopyOptions").getter(CopyCommand.getter(CopyCommand::copyOptions)).setter(CopyCommand.setter(Builder::copyOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TABLE_NAME_FIELD, DATA_TABLE_COLUMNS_FIELD, COPY_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataTableName;
    private final String dataTableColumns;
    private final String copyOptions;

    private CopyCommand(BuilderImpl builder) {
        this.dataTableName = builder.dataTableName;
        this.dataTableColumns = builder.dataTableColumns;
        this.copyOptions = builder.copyOptions;
    }

    public String dataTableName() {
        return this.dataTableName;
    }

    public String dataTableColumns() {
        return this.dataTableColumns;
    }

    public String copyOptions() {
        return this.copyOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableColumns());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyCommand)) {
            return false;
        }
        CopyCommand other = (CopyCommand)obj;
        return Objects.equals(this.dataTableName(), other.dataTableName()) && Objects.equals(this.dataTableColumns(), other.dataTableColumns()) && Objects.equals(this.copyOptions(), other.copyOptions());
    }

    public String toString() {
        return ToString.builder((String)"CopyCommand").add("DataTableName", (Object)this.dataTableName()).add("DataTableColumns", (Object)this.dataTableColumns()).add("CopyOptions", (Object)this.copyOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTableName": {
                return Optional.ofNullable(clazz.cast(this.dataTableName()));
            }
            case "DataTableColumns": {
                return Optional.ofNullable(clazz.cast(this.dataTableColumns()));
            }
            case "CopyOptions": {
                return Optional.ofNullable(clazz.cast(this.copyOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyCommand, T> g) {
        return obj -> g.apply((CopyCommand)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataTableName;
        private String dataTableColumns;
        private String copyOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyCommand model) {
            this.dataTableName(model.dataTableName);
            this.dataTableColumns(model.dataTableColumns);
            this.copyOptions(model.copyOptions);
        }

        public final String getDataTableName() {
            return this.dataTableName;
        }

        @Override
        public final Builder dataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
            return this;
        }

        public final void setDataTableName(String dataTableName) {
            this.dataTableName = dataTableName;
        }

        public final String getDataTableColumns() {
            return this.dataTableColumns;
        }

        @Override
        public final Builder dataTableColumns(String dataTableColumns) {
            this.dataTableColumns = dataTableColumns;
            return this;
        }

        public final void setDataTableColumns(String dataTableColumns) {
            this.dataTableColumns = dataTableColumns;
        }

        public final String getCopyOptions() {
            return this.copyOptions;
        }

        @Override
        public final Builder copyOptions(String copyOptions) {
            this.copyOptions = copyOptions;
            return this;
        }

        public final void setCopyOptions(String copyOptions) {
            this.copyOptions = copyOptions;
        }

        public CopyCommand build() {
            return new CopyCommand(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CopyCommand> {
        public Builder dataTableName(String var1);

        public Builder dataTableColumns(String var1);

        public Builder copyOptions(String var1);
    }
}

