/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the VPC of the Amazon ES destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfigurationDescription.Builder, VpcConfigurationDescription> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(VpcConfigurationDescription::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VpcConfigurationDescription::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(VpcConfigurationDescription::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VpcConfigurationDescription::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD,
            ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnetIds;

    private final String roleARN;

    private final List<String> securityGroupIds;

    private final String vpcId;

    private VpcConfigurationDescription(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.roleARN = builder.roleARN;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcId = builder.vpcId;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES destination.
     * Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the subnets whose IDs
     * are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at
     * least one ENI in each of the subnets that are specified here. Do not delete or modify these ENIs.
     * </p>
     * <p>
     * The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down
     * automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match
     * throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that Kinesis
     * Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified here. For
     * more information about ENI quota, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
     * </a> in the Amazon VPC Quotas topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES
     *         destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from
     *         the subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints.
     *         Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not
     *         delete or modify these ENIs.</p>
     *         <p>
     *         The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down
     *         automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to
     *         match throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume
     *         that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets
     *         specified here. For more information about ENI quota, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
     *         Interfaces </a> in the Amazon VPC Quotas topic.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The ARN of the IAM role that you want the delivery stream uses to create endpoints in the destination VPC.
     * </p>
     * 
     * @return The ARN of the IAM role that you want the delivery stream uses to create endpoints in the destination
     *         VPC.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in the VPC of the Amazon ES
     * destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in the VPC of the
     *         Amazon ES destination.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID of the Amazon ES destination's VPC.
     * </p>
     * 
     * @return The ID of the Amazon ES destination's VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigurationDescription)) {
            return false;
        }
        VpcConfigurationDescription other = (VpcConfigurationDescription) obj;
        return Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VpcConfigurationDescription").add("SubnetIds", subnetIds()).add("RoleARN", roleARN())
                .add("SecurityGroupIds", securityGroupIds()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigurationDescription, T> g) {
        return obj -> g.apply((VpcConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfigurationDescription> {
        /**
         * <p>
         * The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES
         * destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the
         * subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis
         * Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or
         * modify these ENIs.
         * </p>
         * <p>
         * The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down
         * automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match
         * throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that
         * Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified
         * here. For more information about ENI quota, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
         * Interfaces </a> in the Amazon VPC Quotas topic.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES
         *        destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow
         *        from the subnets whose IDs are specified here to the subnets that have the destination Amazon ES
         *        endpoints. Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified
         *        here. Do not delete or modify these ENIs.</p>
         *        <p>
         *        The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down
         *        automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to
         *        match throughput, ensure that you have sufficient quota. To help you calculate the quota you need,
         *        assume that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the
         *        subnets specified here. For more information about ENI quota, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
         *        Interfaces </a> in the Amazon VPC Quotas topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES
         * destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the
         * subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis
         * Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or
         * modify these ENIs.
         * </p>
         * <p>
         * The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down
         * automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match
         * throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that
         * Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified
         * here. For more information about ENI quota, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
         * Interfaces </a> in the Amazon VPC Quotas topic.
         * </p>
         * 
         * @param subnetIds
         *        The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES
         *        destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow
         *        from the subnets whose IDs are specified here to the subnets that have the destination Amazon ES
         *        endpoints. Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified
         *        here. Do not delete or modify these ENIs.</p>
         *        <p>
         *        The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down
         *        automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to
         *        match throughput, ensure that you have sufficient quota. To help you calculate the quota you need,
         *        assume that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the
         *        subnets specified here. For more information about ENI quota, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network
         *        Interfaces </a> in the Amazon VPC Quotas topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The ARN of the IAM role that you want the delivery stream uses to create endpoints in the destination VPC.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the IAM role that you want the delivery stream uses to create endpoints in the destination
         *        VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in the VPC of the Amazon
         * ES destination.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in the VPC of the
         *        Amazon ES destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in the VPC of the Amazon
         * ES destination.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in the VPC of the
         *        Amazon ES destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID of the Amazon ES destination's VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon ES destination's VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String roleARN;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigurationDescription model) {
            subnetIds(model.subnetIds);
            roleARN(model.roleARN);
            securityGroupIds(model.securityGroupIds);
            vpcId(model.vpcId);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public VpcConfigurationDescription build() {
            return new VpcConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
