/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data before it
 * writes it to Amazon S3. This parameter is required if <code>Enabled</code> is set to true.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputFormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputFormatConfiguration.Builder, OutputFormatConfiguration> {
    private static final SdkField<Serializer> SERIALIZER_FIELD = SdkField.<Serializer> builder(MarshallingType.SDK_POJO)
            .getter(getter(OutputFormatConfiguration::serializer)).setter(setter(Builder::serializer))
            .constructor(Serializer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serializer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERIALIZER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Serializer serializer;

    private OutputFormatConfiguration(BuilderImpl builder) {
        this.serializer = builder.serializer;
    }

    /**
     * <p>
     * Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet SerDe. If both are
     * non-null, the server rejects the request.
     * </p>
     * 
     * @return Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet SerDe. If both are
     *         non-null, the server rejects the request.
     */
    public Serializer serializer() {
        return serializer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serializer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputFormatConfiguration)) {
            return false;
        }
        OutputFormatConfiguration other = (OutputFormatConfiguration) obj;
        return Objects.equals(serializer(), other.serializer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutputFormatConfiguration").add("Serializer", serializer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Serializer":
            return Optional.ofNullable(clazz.cast(serializer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputFormatConfiguration, T> g) {
        return obj -> g.apply((OutputFormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputFormatConfiguration> {
        /**
         * <p>
         * Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet SerDe. If both are
         * non-null, the server rejects the request.
         * </p>
         * 
         * @param serializer
         *        Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet SerDe. If both
         *        are non-null, the server rejects the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serializer(Serializer serializer);

        /**
         * <p>
         * Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet SerDe. If both are
         * non-null, the server rejects the request.
         * </p>
         * This is a convenience that creates an instance of the {@link Serializer.Builder} avoiding the need to create
         * one manually via {@link Serializer#builder()}.
         *
         * When the {@link Consumer} completes, {@link Serializer.Builder#build()} is called immediately and its result
         * is passed to {@link #serializer(Serializer)}.
         * 
         * @param serializer
         *        a consumer that will call methods on {@link Serializer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serializer(Serializer)
         */
        default Builder serializer(Consumer<Serializer.Builder> serializer) {
            return serializer(Serializer.builder().applyMutation(serializer).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Serializer serializer;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputFormatConfiguration model) {
            serializer(model.serializer);
        }

        public final Serializer.Builder getSerializer() {
            return serializer != null ? serializer.toBuilder() : null;
        }

        @Override
        public final Builder serializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public final void setSerializer(Serializer.BuilderImpl serializer) {
            this.serializer = serializer != null ? serializer.build() : null;
        }

        @Override
        public OutputFormatConfiguration build() {
            return new OutputFormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
