/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it
 * from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers
 * you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HiveJsonSerDe implements SdkPojo, Serializable, ToCopyableBuilder<HiveJsonSerDe.Builder, HiveJsonSerDe> {
    private static final SdkField<List<String>> TIMESTAMP_FORMATS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(HiveJsonSerDe::timestampFormats))
            .setter(setter(Builder::timestampFormats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FORMATS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> timestampFormats;

    private HiveJsonSerDe(BuilderImpl builder) {
        this.timestampFormats = builder.timestampFormats;
    }

    /**
     * Returns true if the TimestampFormats property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTimestampFormats() {
        return timestampFormats != null && !(timestampFormats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in your input
     * data JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format
     * strings. For more information, see <a
     * href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a>.
     * You can also use the special value <code>millis</code> to parse timestamps in epoch milliseconds. If you don't
     * specify a format, Kinesis Data Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTimestampFormats()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in your
     *         input data JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat
     *         format strings. For more information, see <a
     *         href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
     *         DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in epoch
     *         milliseconds. If you don't specify a format, Kinesis Data Firehose uses
     *         <code>java.sql.Timestamp::valueOf</code> by default.
     */
    public List<String> timestampFormats() {
        return timestampFormats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormats());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HiveJsonSerDe)) {
            return false;
        }
        HiveJsonSerDe other = (HiveJsonSerDe) obj;
        return Objects.equals(timestampFormats(), other.timestampFormats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HiveJsonSerDe").add("TimestampFormats", timestampFormats()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimestampFormats":
            return Optional.ofNullable(clazz.cast(timestampFormats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HiveJsonSerDe, T> g) {
        return obj -> g.apply((HiveJsonSerDe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HiveJsonSerDe> {
        /**
         * <p>
         * Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in your
         * input data JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat
         * format strings. For more information, see <a
         * href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
         * DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in epoch
         * milliseconds. If you don't specify a format, Kinesis Data Firehose uses
         * <code>java.sql.Timestamp::valueOf</code> by default.
         * </p>
         * 
         * @param timestampFormats
         *        Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in
         *        your input data JSON. To specify these format strings, follow the pattern syntax of JodaTime's
         *        DateTimeFormat format strings. For more information, see <a
         *        href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
         *        DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in
         *        epoch milliseconds. If you don't specify a format, Kinesis Data Firehose uses
         *        <code>java.sql.Timestamp::valueOf</code> by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormats(Collection<String> timestampFormats);

        /**
         * <p>
         * Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in your
         * input data JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat
         * format strings. For more information, see <a
         * href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
         * DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in epoch
         * milliseconds. If you don't specify a format, Kinesis Data Firehose uses
         * <code>java.sql.Timestamp::valueOf</code> by default.
         * </p>
         * 
         * @param timestampFormats
         *        Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in
         *        your input data JSON. To specify these format strings, follow the pattern syntax of JodaTime's
         *        DateTimeFormat format strings. For more information, see <a
         *        href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
         *        DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in
         *        epoch milliseconds. If you don't specify a format, Kinesis Data Firehose uses
         *        <code>java.sql.Timestamp::valueOf</code> by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormats(String... timestampFormats);
    }

    static final class BuilderImpl implements Builder {
        private List<String> timestampFormats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HiveJsonSerDe model) {
            timestampFormats(model.timestampFormats);
        }

        public final Collection<String> getTimestampFormats() {
            return timestampFormats;
        }

        @Override
        public final Builder timestampFormats(Collection<String> timestampFormats) {
            this.timestampFormats = ListOfNonEmptyStringsCopier.copy(timestampFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampFormats(String... timestampFormats) {
            timestampFormats(Arrays.asList(timestampFormats));
            return this;
        }

        public final void setTimestampFormats(Collection<String> timestampFormats) {
            this.timestampFormats = ListOfNonEmptyStringsCopier.copy(timestampFormats);
        }

        @Override
        public HiveJsonSerDe build() {
            return new HiveJsonSerDe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
