/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details in case one of the following operations fails due to an error related to KMS:
 * <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>,
 * <a>StopDeliveryStreamEncryption</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailureDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<FailureDescription.Builder, FailureDescription> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FailureDescription::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FailureDescription::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String details;

    private FailureDescription(BuilderImpl builder) {
        this.type = builder.type;
        this.details = builder.details;
    }

    /**
     * <p>
     * The type of error that caused the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeliveryStreamFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of error that caused the failure.
     * @see DeliveryStreamFailureType
     */
    public DeliveryStreamFailureType type() {
        return DeliveryStreamFailureType.fromValue(type);
    }

    /**
     * <p>
     * The type of error that caused the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeliveryStreamFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of error that caused the failure.
     * @see DeliveryStreamFailureType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A message providing details about the error that caused the failure.
     * </p>
     * 
     * @return A message providing details about the error that caused the failure.
     */
    public String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDescription)) {
            return false;
        }
        FailureDescription other = (FailureDescription) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FailureDescription").add("Type", typeAsString()).add("Details", details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailureDescription, T> g) {
        return obj -> g.apply((FailureDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailureDescription> {
        /**
         * <p>
         * The type of error that caused the failure.
         * </p>
         * 
         * @param type
         *        The type of error that caused the failure.
         * @see DeliveryStreamFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamFailureType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of error that caused the failure.
         * </p>
         * 
         * @param type
         *        The type of error that caused the failure.
         * @see DeliveryStreamFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamFailureType
         */
        Builder type(DeliveryStreamFailureType type);

        /**
         * <p>
         * A message providing details about the error that caused the failure.
         * </p>
         * 
         * @param details
         *        A message providing details about the error that caused the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDescription model) {
            type(model.type);
            details(model.details);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeliveryStreamFailureType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public FailureDescription build() {
            return new FailureDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
