/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the destination for a delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationDescription.Builder, DestinationDescription> {
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DestinationDescription::destinationId)).setter(setter(Builder::destinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationId").build()).build();

    private static final SdkField<S3DestinationDescription> S3_DESTINATION_DESCRIPTION_FIELD = SdkField
            .<S3DestinationDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DestinationDescription::s3DestinationDescription)).setter(setter(Builder::s3DestinationDescription))
            .constructor(S3DestinationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationDescription").build())
            .build();

    private static final SdkField<ExtendedS3DestinationDescription> EXTENDED_S3_DESTINATION_DESCRIPTION_FIELD = SdkField
            .<ExtendedS3DestinationDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DestinationDescription::extendedS3DestinationDescription))
            .setter(setter(Builder::extendedS3DestinationDescription))
            .constructor(ExtendedS3DestinationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedS3DestinationDescription")
                    .build()).build();

    private static final SdkField<RedshiftDestinationDescription> REDSHIFT_DESTINATION_DESCRIPTION_FIELD = SdkField
            .<RedshiftDestinationDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DestinationDescription::redshiftDestinationDescription))
            .setter(setter(Builder::redshiftDestinationDescription))
            .constructor(RedshiftDestinationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDestinationDescription")
                    .build()).build();

    private static final SdkField<ElasticsearchDestinationDescription> ELASTICSEARCH_DESTINATION_DESCRIPTION_FIELD = SdkField
            .<ElasticsearchDestinationDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DestinationDescription::elasticsearchDestinationDescription))
            .setter(setter(Builder::elasticsearchDestinationDescription))
            .constructor(ElasticsearchDestinationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ElasticsearchDestinationDescription").build()).build();

    private static final SdkField<SplunkDestinationDescription> SPLUNK_DESTINATION_DESCRIPTION_FIELD = SdkField
            .<SplunkDestinationDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DestinationDescription::splunkDestinationDescription))
            .setter(setter(Builder::splunkDestinationDescription))
            .constructor(SplunkDestinationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplunkDestinationDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ID_FIELD,
            S3_DESTINATION_DESCRIPTION_FIELD, EXTENDED_S3_DESTINATION_DESCRIPTION_FIELD, REDSHIFT_DESTINATION_DESCRIPTION_FIELD,
            ELASTICSEARCH_DESTINATION_DESCRIPTION_FIELD, SPLUNK_DESTINATION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationId;

    private final S3DestinationDescription s3DestinationDescription;

    private final ExtendedS3DestinationDescription extendedS3DestinationDescription;

    private final RedshiftDestinationDescription redshiftDestinationDescription;

    private final ElasticsearchDestinationDescription elasticsearchDestinationDescription;

    private final SplunkDestinationDescription splunkDestinationDescription;

    private DestinationDescription(BuilderImpl builder) {
        this.destinationId = builder.destinationId;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.extendedS3DestinationDescription = builder.extendedS3DestinationDescription;
        this.redshiftDestinationDescription = builder.redshiftDestinationDescription;
        this.elasticsearchDestinationDescription = builder.elasticsearchDestinationDescription;
        this.splunkDestinationDescription = builder.splunkDestinationDescription;
    }

    /**
     * <p>
     * The ID of the destination.
     * </p>
     * 
     * @return The ID of the destination.
     */
    public String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * [Deprecated] The destination in Amazon S3.
     * </p>
     * 
     * @return [Deprecated] The destination in Amazon S3.
     */
    public S3DestinationDescription s3DestinationDescription() {
        return s3DestinationDescription;
    }

    /**
     * <p>
     * The destination in Amazon S3.
     * </p>
     * 
     * @return The destination in Amazon S3.
     */
    public ExtendedS3DestinationDescription extendedS3DestinationDescription() {
        return extendedS3DestinationDescription;
    }

    /**
     * <p>
     * The destination in Amazon Redshift.
     * </p>
     * 
     * @return The destination in Amazon Redshift.
     */
    public RedshiftDestinationDescription redshiftDestinationDescription() {
        return redshiftDestinationDescription;
    }

    /**
     * <p>
     * The destination in Amazon ES.
     * </p>
     * 
     * @return The destination in Amazon ES.
     */
    public ElasticsearchDestinationDescription elasticsearchDestinationDescription() {
        return elasticsearchDestinationDescription;
    }

    /**
     * <p>
     * The destination in Splunk.
     * </p>
     * 
     * @return The destination in Splunk.
     */
    public SplunkDestinationDescription splunkDestinationDescription() {
        return splunkDestinationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(extendedS3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchDestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(splunkDestinationDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationDescription)) {
            return false;
        }
        DestinationDescription other = (DestinationDescription) obj;
        return Objects.equals(destinationId(), other.destinationId())
                && Objects.equals(s3DestinationDescription(), other.s3DestinationDescription())
                && Objects.equals(extendedS3DestinationDescription(), other.extendedS3DestinationDescription())
                && Objects.equals(redshiftDestinationDescription(), other.redshiftDestinationDescription())
                && Objects.equals(elasticsearchDestinationDescription(), other.elasticsearchDestinationDescription())
                && Objects.equals(splunkDestinationDescription(), other.splunkDestinationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DestinationDescription").add("DestinationId", destinationId())
                .add("S3DestinationDescription", s3DestinationDescription())
                .add("ExtendedS3DestinationDescription", extendedS3DestinationDescription())
                .add("RedshiftDestinationDescription", redshiftDestinationDescription())
                .add("ElasticsearchDestinationDescription", elasticsearchDestinationDescription())
                .add("SplunkDestinationDescription", splunkDestinationDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationId":
            return Optional.ofNullable(clazz.cast(destinationId()));
        case "S3DestinationDescription":
            return Optional.ofNullable(clazz.cast(s3DestinationDescription()));
        case "ExtendedS3DestinationDescription":
            return Optional.ofNullable(clazz.cast(extendedS3DestinationDescription()));
        case "RedshiftDestinationDescription":
            return Optional.ofNullable(clazz.cast(redshiftDestinationDescription()));
        case "ElasticsearchDestinationDescription":
            return Optional.ofNullable(clazz.cast(elasticsearchDestinationDescription()));
        case "SplunkDestinationDescription":
            return Optional.ofNullable(clazz.cast(splunkDestinationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationDescription, T> g) {
        return obj -> g.apply((DestinationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationDescription> {
        /**
         * <p>
         * The ID of the destination.
         * </p>
         * 
         * @param destinationId
         *        The ID of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * [Deprecated] The destination in Amazon S3.
         * </p>
         * 
         * @param s3DestinationDescription
         *        [Deprecated] The destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription);

        /**
         * <p>
         * [Deprecated] The destination in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationDescription.Builder} avoiding the
         * need to create one manually via {@link S3DestinationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #s3DestinationDescription(S3DestinationDescription)}.
         * 
         * @param s3DestinationDescription
         *        a consumer that will call methods on {@link S3DestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationDescription(S3DestinationDescription)
         */
        default Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return s3DestinationDescription(S3DestinationDescription.builder().applyMutation(s3DestinationDescription).build());
        }

        /**
         * <p>
         * The destination in Amazon S3.
         * </p>
         * 
         * @param extendedS3DestinationDescription
         *        The destination in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription extendedS3DestinationDescription);

        /**
         * <p>
         * The destination in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link ExtendedS3DestinationDescription.Builder}
         * avoiding the need to create one manually via {@link ExtendedS3DestinationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExtendedS3DestinationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #extendedS3DestinationDescription(ExtendedS3DestinationDescription)}.
         * 
         * @param extendedS3DestinationDescription
         *        a consumer that will call methods on {@link ExtendedS3DestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extendedS3DestinationDescription(ExtendedS3DestinationDescription)
         */
        default Builder extendedS3DestinationDescription(
                Consumer<ExtendedS3DestinationDescription.Builder> extendedS3DestinationDescription) {
            return extendedS3DestinationDescription(ExtendedS3DestinationDescription.builder()
                    .applyMutation(extendedS3DestinationDescription).build());
        }

        /**
         * <p>
         * The destination in Amazon Redshift.
         * </p>
         * 
         * @param redshiftDestinationDescription
         *        The destination in Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDestinationDescription(RedshiftDestinationDescription redshiftDestinationDescription);

        /**
         * <p>
         * The destination in Amazon Redshift.
         * </p>
         * This is a convenience that creates an instance of the {@link RedshiftDestinationDescription.Builder} avoiding
         * the need to create one manually via {@link RedshiftDestinationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftDestinationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #redshiftDestinationDescription(RedshiftDestinationDescription)}.
         * 
         * @param redshiftDestinationDescription
         *        a consumer that will call methods on {@link RedshiftDestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDestinationDescription(RedshiftDestinationDescription)
         */
        default Builder redshiftDestinationDescription(
                Consumer<RedshiftDestinationDescription.Builder> redshiftDestinationDescription) {
            return redshiftDestinationDescription(RedshiftDestinationDescription.builder()
                    .applyMutation(redshiftDestinationDescription).build());
        }

        /**
         * <p>
         * The destination in Amazon ES.
         * </p>
         * 
         * @param elasticsearchDestinationDescription
         *        The destination in Amazon ES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchDestinationDescription(ElasticsearchDestinationDescription elasticsearchDestinationDescription);

        /**
         * <p>
         * The destination in Amazon ES.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchDestinationDescription.Builder}
         * avoiding the need to create one manually via {@link ElasticsearchDestinationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchDestinationDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #elasticsearchDestinationDescription(ElasticsearchDestinationDescription)}.
         * 
         * @param elasticsearchDestinationDescription
         *        a consumer that will call methods on {@link ElasticsearchDestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchDestinationDescription(ElasticsearchDestinationDescription)
         */
        default Builder elasticsearchDestinationDescription(
                Consumer<ElasticsearchDestinationDescription.Builder> elasticsearchDestinationDescription) {
            return elasticsearchDestinationDescription(ElasticsearchDestinationDescription.builder()
                    .applyMutation(elasticsearchDestinationDescription).build());
        }

        /**
         * <p>
         * The destination in Splunk.
         * </p>
         * 
         * @param splunkDestinationDescription
         *        The destination in Splunk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splunkDestinationDescription(SplunkDestinationDescription splunkDestinationDescription);

        /**
         * <p>
         * The destination in Splunk.
         * </p>
         * This is a convenience that creates an instance of the {@link SplunkDestinationDescription.Builder} avoiding
         * the need to create one manually via {@link SplunkDestinationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link SplunkDestinationDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #splunkDestinationDescription(SplunkDestinationDescription)}.
         * 
         * @param splunkDestinationDescription
         *        a consumer that will call methods on {@link SplunkDestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splunkDestinationDescription(SplunkDestinationDescription)
         */
        default Builder splunkDestinationDescription(Consumer<SplunkDestinationDescription.Builder> splunkDestinationDescription) {
            return splunkDestinationDescription(SplunkDestinationDescription.builder()
                    .applyMutation(splunkDestinationDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destinationId;

        private S3DestinationDescription s3DestinationDescription;

        private ExtendedS3DestinationDescription extendedS3DestinationDescription;

        private RedshiftDestinationDescription redshiftDestinationDescription;

        private ElasticsearchDestinationDescription elasticsearchDestinationDescription;

        private SplunkDestinationDescription splunkDestinationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationDescription model) {
            destinationId(model.destinationId);
            s3DestinationDescription(model.s3DestinationDescription);
            extendedS3DestinationDescription(model.extendedS3DestinationDescription);
            redshiftDestinationDescription(model.redshiftDestinationDescription);
            elasticsearchDestinationDescription(model.elasticsearchDestinationDescription);
            splunkDestinationDescription(model.splunkDestinationDescription);
        }

        public final String getDestinationId() {
            return destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return s3DestinationDescription != null ? s3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        public final ExtendedS3DestinationDescription.Builder getExtendedS3DestinationDescription() {
            return extendedS3DestinationDescription != null ? extendedS3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription;
            return this;
        }

        public final void setExtendedS3DestinationDescription(
                ExtendedS3DestinationDescription.BuilderImpl extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription != null ? extendedS3DestinationDescription
                    .build() : null;
        }

        public final RedshiftDestinationDescription.Builder getRedshiftDestinationDescription() {
            return redshiftDestinationDescription != null ? redshiftDestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationDescription(RedshiftDestinationDescription redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription;
            return this;
        }

        public final void setRedshiftDestinationDescription(
                RedshiftDestinationDescription.BuilderImpl redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription != null ? redshiftDestinationDescription.build()
                    : null;
        }

        public final ElasticsearchDestinationDescription.Builder getElasticsearchDestinationDescription() {
            return elasticsearchDestinationDescription != null ? elasticsearchDestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationDescription(
                ElasticsearchDestinationDescription elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription;
            return this;
        }

        public final void setElasticsearchDestinationDescription(
                ElasticsearchDestinationDescription.BuilderImpl elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription != null ? elasticsearchDestinationDescription
                    .build() : null;
        }

        public final SplunkDestinationDescription.Builder getSplunkDestinationDescription() {
            return splunkDestinationDescription != null ? splunkDestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder splunkDestinationDescription(SplunkDestinationDescription splunkDestinationDescription) {
            this.splunkDestinationDescription = splunkDestinationDescription;
            return this;
        }

        public final void setSplunkDestinationDescription(SplunkDestinationDescription.BuilderImpl splunkDestinationDescription) {
            this.splunkDestinationDescription = splunkDestinationDescription != null ? splunkDestinationDescription.build()
                    : null;
        }

        @Override
        public DestinationDescription build() {
            return new DestinationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
