/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a data processing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessingConfiguration.Builder, ProcessingConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ProcessingConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<Processor>> PROCESSORS_FIELD = SdkField
            .<List<Processor>> builder(MarshallingType.LIST)
            .getter(getter(ProcessingConfiguration::processors))
            .setter(setter(Builder::processors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Processor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Processor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            PROCESSORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final List<Processor> processors;

    private ProcessingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.processors = builder.processors;
    }

    /**
     * <p>
     * Enables or disables data processing.
     * </p>
     * 
     * @return Enables or disables data processing.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * Returns true if the Processors property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProcessors() {
        return processors != null && !(processors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data processors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The data processors.
     */
    public List<Processor> processors() {
        return processors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(processors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingConfiguration)) {
            return false;
        }
        ProcessingConfiguration other = (ProcessingConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(processors(), other.processors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProcessingConfiguration").add("Enabled", enabled()).add("Processors", processors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Processors":
            return Optional.ofNullable(clazz.cast(processors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingConfiguration, T> g) {
        return obj -> g.apply((ProcessingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingConfiguration> {
        /**
         * <p>
         * Enables or disables data processing.
         * </p>
         * 
         * @param enabled
         *        Enables or disables data processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The data processors.
         * </p>
         * 
         * @param processors
         *        The data processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Collection<Processor> processors);

        /**
         * <p>
         * The data processors.
         * </p>
         * 
         * @param processors
         *        The data processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Processor... processors);

        /**
         * <p>
         * The data processors.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Processor>.Builder} avoiding the need to
         * create one manually via {@link List<Processor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Processor>.Builder#build()} is called immediately and its
         * result is passed to {@link #processors(List<Processor>)}.
         * 
         * @param processors
         *        a consumer that will call methods on {@link List<Processor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processors(List<Processor>)
         */
        Builder processors(Consumer<Processor.Builder>... processors);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private List<Processor> processors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingConfiguration model) {
            enabled(model.enabled);
            processors(model.processors);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Processor.Builder> getProcessors() {
            return processors != null ? processors.stream().map(Processor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor... processors) {
            processors(Arrays.asList(processors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Consumer<Processor.Builder>... processors) {
            processors(Stream.of(processors).map(c -> Processor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessors(Collection<Processor.BuilderImpl> processors) {
            this.processors = ProcessorListCopier.copyFromBuilder(processors);
        }

        @Override
        public ProcessingConfiguration build() {
            return new ProcessingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
