/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeliveryStreamsResponse extends FirehoseResponse implements
        ToCopyableBuilder<ListDeliveryStreamsResponse.Builder, ListDeliveryStreamsResponse> {
    private static final SdkField<List<String>> DELIVERY_STREAM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListDeliveryStreamsResponse::deliveryStreamNames))
            .setter(setter(Builder::deliveryStreamNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> HAS_MORE_DELIVERY_STREAMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListDeliveryStreamsResponse::hasMoreDeliveryStreams)).setter(setter(Builder::hasMoreDeliveryStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreDeliveryStreams").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAMES_FIELD,
            HAS_MORE_DELIVERY_STREAMS_FIELD));

    private final List<String> deliveryStreamNames;

    private final Boolean hasMoreDeliveryStreams;

    private ListDeliveryStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamNames = builder.deliveryStreamNames;
        this.hasMoreDeliveryStreams = builder.hasMoreDeliveryStreams;
    }

    /**
     * Returns true if the DeliveryStreamNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDeliveryStreamNames() {
        return deliveryStreamNames != null && !(deliveryStreamNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the delivery streams.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeliveryStreamNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the delivery streams.
     */
    public List<String> deliveryStreamNames() {
        return deliveryStreamNames;
    }

    /**
     * <p>
     * Indicates whether there are more delivery streams available to list.
     * </p>
     * 
     * @return Indicates whether there are more delivery streams available to list.
     */
    public Boolean hasMoreDeliveryStreams() {
        return hasMoreDeliveryStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamNames());
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreDeliveryStreams());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsResponse)) {
            return false;
        }
        ListDeliveryStreamsResponse other = (ListDeliveryStreamsResponse) obj;
        return Objects.equals(deliveryStreamNames(), other.deliveryStreamNames())
                && Objects.equals(hasMoreDeliveryStreams(), other.hasMoreDeliveryStreams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDeliveryStreamsResponse").add("DeliveryStreamNames", deliveryStreamNames())
                .add("HasMoreDeliveryStreams", hasMoreDeliveryStreams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamNames":
            return Optional.ofNullable(clazz.cast(deliveryStreamNames()));
        case "HasMoreDeliveryStreams":
            return Optional.ofNullable(clazz.cast(hasMoreDeliveryStreams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeliveryStreamsResponse, T> g) {
        return obj -> g.apply((ListDeliveryStreamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDeliveryStreamsResponse> {
        /**
         * <p>
         * The names of the delivery streams.
         * </p>
         * 
         * @param deliveryStreamNames
         *        The names of the delivery streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamNames(Collection<String> deliveryStreamNames);

        /**
         * <p>
         * The names of the delivery streams.
         * </p>
         * 
         * @param deliveryStreamNames
         *        The names of the delivery streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamNames(String... deliveryStreamNames);

        /**
         * <p>
         * Indicates whether there are more delivery streams available to list.
         * </p>
         * 
         * @param hasMoreDeliveryStreams
         *        Indicates whether there are more delivery streams available to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams);
    }

    static final class BuilderImpl extends FirehoseResponse.BuilderImpl implements Builder {
        private List<String> deliveryStreamNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean hasMoreDeliveryStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsResponse model) {
            super(model);
            deliveryStreamNames(model.deliveryStreamNames);
            hasMoreDeliveryStreams(model.hasMoreDeliveryStreams);
        }

        public final Collection<String> getDeliveryStreamNames() {
            return deliveryStreamNames;
        }

        @Override
        public final Builder deliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryStreamNames(String... deliveryStreamNames) {
            deliveryStreamNames(Arrays.asList(deliveryStreamNames));
            return this;
        }

        public final void setDeliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
        }

        public final Boolean getHasMoreDeliveryStreams() {
            return hasMoreDeliveryStreams;
        }

        @Override
        public final Builder hasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
            return this;
        }

        public final void setHasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
        }

        @Override
        public ListDeliveryStreamsResponse build() {
            return new ListDeliveryStreamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
