/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a destination in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtendedS3DestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExtendedS3DestinationConfiguration.Builder, ExtendedS3DestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExtendedS3DestinationConfiguration::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExtendedS3DestinationConfiguration::bucketARN)).setter(setter(Builder::bucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExtendedS3DestinationConfiguration::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> ERROR_OUTPUT_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExtendedS3DestinationConfiguration::errorOutputPrefix)).setter(setter(Builder::errorOutputPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorOutputPrefix").build()).build();

    private static final SdkField<BufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<BufferingHints> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExtendedS3DestinationConfiguration::bufferingHints)).setter(setter(Builder::bufferingHints))
            .constructor(BufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final SdkField<String> COMPRESSION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExtendedS3DestinationConfiguration::compressionFormatAsString))
            .setter(setter(Builder::compressionFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionFormat").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExtendedS3DestinationConfiguration::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExtendedS3DestinationConfiguration::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExtendedS3DestinationConfiguration::processingConfiguration))
            .setter(setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build())
            .build();

    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExtendedS3DestinationConfiguration::s3BackupModeAsString)).setter(setter(Builder::s3BackupMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()).build();

    private static final SdkField<S3DestinationConfiguration> S3_BACKUP_CONFIGURATION_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExtendedS3DestinationConfiguration::s3BackupConfiguration))
            .setter(setter(Builder::s3BackupConfiguration)).constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupConfiguration").build())
            .build();

    private static final SdkField<DataFormatConversionConfiguration> DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD = SdkField
            .<DataFormatConversionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExtendedS3DestinationConfiguration::dataFormatConversionConfiguration))
            .setter(setter(Builder::dataFormatConversionConfiguration))
            .constructor(DataFormatConversionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormatConversionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            BUCKET_ARN_FIELD, PREFIX_FIELD, ERROR_OUTPUT_PREFIX_FIELD, BUFFERING_HINTS_FIELD, COMPRESSION_FORMAT_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD,
            S3_BACKUP_MODE_FIELD, S3_BACKUP_CONFIGURATION_FIELD, DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleARN;

    private final String bucketARN;

    private final String prefix;

    private final String errorOutputPrefix;

    private final BufferingHints bufferingHints;

    private final String compressionFormat;

    private final EncryptionConfiguration encryptionConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private final ProcessingConfiguration processingConfiguration;

    private final String s3BackupMode;

    private final S3DestinationConfiguration s3BackupConfiguration;

    private final DataFormatConversionConfiguration dataFormatConversionConfiguration;

    private ExtendedS3DestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.errorOutputPrefix = builder.errorOutputPrefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupConfiguration = builder.s3BackupConfiguration;
        this.dataFormatConversionConfiguration = builder.dataFormatConversionConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a>.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a>.
     * </p>
     * 
     * @return The ARN of the S3 bucket. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a>.
     */
    public String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify
     * a custom prefix, as described in <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
     * Objects</a>.
     * </p>
     * 
     * @return The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also
     *         specify a custom prefix, as described in <a
     *         href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
     *         Objects</a>.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix
     * appears immediately following the bucket name. For information about how to specify this prefix, see <a
     * href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
     * Objects</a>.
     * </p>
     * 
     * @return A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This
     *         prefix appears immediately following the bucket name. For information about how to specify this prefix,
     *         see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon
     *         S3 Objects</a>.
     */
    public String errorOutputPrefix() {
        return errorOutputPrefix;
    }

    /**
     * <p>
     * The buffering option.
     * </p>
     * 
     * @return The buffering option.
     */
    public BufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The compression format. If no value is specified, the default is UNCOMPRESSED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionFormat}
     * will return {@link CompressionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionFormatAsString}.
     * </p>
     * 
     * @return The compression format. If no value is specified, the default is UNCOMPRESSED.
     * @see CompressionFormat
     */
    public CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(compressionFormat);
    }

    /**
     * <p>
     * The compression format. If no value is specified, the default is UNCOMPRESSED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionFormat}
     * will return {@link CompressionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #compressionFormatAsString}.
     * </p>
     * 
     * @return The compression format. If no value is specified, the default is UNCOMPRESSED.
     * @see CompressionFormat
     */
    public String compressionFormatAsString() {
        return compressionFormat;
    }

    /**
     * <p>
     * The encryption configuration. If no value is specified, the default is no encryption.
     * </p>
     * 
     * @return The encryption configuration. If no value is specified, the default is no encryption.
     */
    public EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * The Amazon CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The Amazon CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link S3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see S3BackupMode
     */
    public S3BackupMode s3BackupMode() {
        return S3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link S3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see S3BackupMode
     */
    public String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * <p>
     * The configuration for backup in Amazon S3.
     * </p>
     * 
     * @return The configuration for backup in Amazon S3.
     */
    public S3DestinationConfiguration s3BackupConfiguration() {
        return s3BackupConfiguration;
    }

    /**
     * <p>
     * The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format
     * before writing it to Amazon S3.
     * </p>
     * 
     * @return The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC
     *         format before writing it to Amazon S3.
     */
    public DataFormatConversionConfiguration dataFormatConversionConfiguration() {
        return dataFormatConversionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(errorOutputPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(compressionFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatConversionConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedS3DestinationConfiguration)) {
            return false;
        }
        ExtendedS3DestinationConfiguration other = (ExtendedS3DestinationConfiguration) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(bucketARN(), other.bucketARN())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(errorOutputPrefix(), other.errorOutputPrefix())
                && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(compressionFormatAsString(), other.compressionFormatAsString())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(s3BackupConfiguration(), other.s3BackupConfiguration())
                && Objects.equals(dataFormatConversionConfiguration(), other.dataFormatConversionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExtendedS3DestinationConfiguration").add("RoleARN", roleARN()).add("BucketARN", bucketARN())
                .add("Prefix", prefix()).add("ErrorOutputPrefix", errorOutputPrefix()).add("BufferingHints", bufferingHints())
                .add("CompressionFormat", compressionFormatAsString()).add("EncryptionConfiguration", encryptionConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions())
                .add("ProcessingConfiguration", processingConfiguration()).add("S3BackupMode", s3BackupModeAsString())
                .add("S3BackupConfiguration", s3BackupConfiguration())
                .add("DataFormatConversionConfiguration", dataFormatConversionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "BucketARN":
            return Optional.ofNullable(clazz.cast(bucketARN()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "ErrorOutputPrefix":
            return Optional.ofNullable(clazz.cast(errorOutputPrefix()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        case "CompressionFormat":
            return Optional.ofNullable(clazz.cast(compressionFormatAsString()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "ProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "S3BackupMode":
            return Optional.ofNullable(clazz.cast(s3BackupModeAsString()));
        case "S3BackupConfiguration":
            return Optional.ofNullable(clazz.cast(s3BackupConfiguration()));
        case "DataFormatConversionConfiguration":
            return Optional.ofNullable(clazz.cast(dataFormatConversionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtendedS3DestinationConfiguration, T> g) {
        return obj -> g.apply((ExtendedS3DestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtendedS3DestinationConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a>.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the S3 bucket. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a>.
         * </p>
         * 
         * @param bucketARN
         *        The ARN of the S3 bucket. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also
         * specify a custom prefix, as described in <a
         * href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
         * Objects</a>.
         * </p>
         * 
         * @param prefix
         *        The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can
         *        also specify a custom prefix, as described in <a
         *        href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
         *        Objects</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This
         * prefix appears immediately following the bucket name. For information about how to specify this prefix, see
         * <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3
         * Objects</a>.
         * </p>
         * 
         * @param errorOutputPrefix
         *        A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
         *        This prefix appears immediately following the bucket name. For information about how to specify this
         *        prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes
         *        for Amazon S3 Objects</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorOutputPrefix(String errorOutputPrefix);

        /**
         * <p>
         * The buffering option.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(BufferingHints bufferingHints);

        /**
         * <p>
         * The buffering option.
         * </p>
         * This is a convenience that creates an instance of the {@link BufferingHints.Builder} avoiding the need to
         * create one manually via {@link BufferingHints#builder()}.
         *
         * When the {@link Consumer} completes, {@link BufferingHints.Builder#build()} is called immediately and its
         * result is passed to {@link #bufferingHints(BufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link BufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(BufferingHints)
         */
        default Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return bufferingHints(BufferingHints.builder().applyMutation(bufferingHints).build());
        }

        /**
         * <p>
         * The compression format. If no value is specified, the default is UNCOMPRESSED.
         * </p>
         * 
         * @param compressionFormat
         *        The compression format. If no value is specified, the default is UNCOMPRESSED.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compressionFormat(String compressionFormat);

        /**
         * <p>
         * The compression format. If no value is specified, the default is UNCOMPRESSED.
         * </p>
         * 
         * @param compressionFormat
         *        The compression format. If no value is specified, the default is UNCOMPRESSED.
         * @see CompressionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionFormat
         */
        Builder compressionFormat(CompressionFormat compressionFormat);

        /**
         * <p>
         * The encryption configuration. If no value is specified, the default is no encryption.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration. If no value is specified, the default is no encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration. If no value is specified, the default is no encryption.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding the
         * need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * The Amazon CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The Amazon CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The Amazon CloudWatch logging options for your delivery stream.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOptions.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding the
         * need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @see S3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @see S3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3BackupMode
         */
        Builder s3BackupMode(S3BackupMode s3BackupMode);

        /**
         * <p>
         * The configuration for backup in Amazon S3.
         * </p>
         * 
         * @param s3BackupConfiguration
         *        The configuration for backup in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BackupConfiguration(S3DestinationConfiguration s3BackupConfiguration);

        /**
         * <p>
         * The configuration for backup in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationConfiguration.Builder} avoiding the
         * need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3BackupConfiguration(S3DestinationConfiguration)}.
         * 
         * @param s3BackupConfiguration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BackupConfiguration(S3DestinationConfiguration)
         */
        default Builder s3BackupConfiguration(Consumer<S3DestinationConfiguration.Builder> s3BackupConfiguration) {
            return s3BackupConfiguration(S3DestinationConfiguration.builder().applyMutation(s3BackupConfiguration).build());
        }

        /**
         * <p>
         * The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC
         * format before writing it to Amazon S3.
         * </p>
         * 
         * @param dataFormatConversionConfiguration
         *        The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or
         *        ORC format before writing it to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration dataFormatConversionConfiguration);

        /**
         * <p>
         * The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC
         * format before writing it to Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link DataFormatConversionConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataFormatConversionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataFormatConversionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dataFormatConversionConfiguration(DataFormatConversionConfiguration)}.
         * 
         * @param dataFormatConversionConfiguration
         *        a consumer that will call methods on {@link DataFormatConversionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataFormatConversionConfiguration(DataFormatConversionConfiguration)
         */
        default Builder dataFormatConversionConfiguration(
                Consumer<DataFormatConversionConfiguration.Builder> dataFormatConversionConfiguration) {
            return dataFormatConversionConfiguration(DataFormatConversionConfiguration.builder()
                    .applyMutation(dataFormatConversionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String bucketARN;

        private String prefix;

        private String errorOutputPrefix;

        private BufferingHints bufferingHints;

        private String compressionFormat;

        private EncryptionConfiguration encryptionConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private ProcessingConfiguration processingConfiguration;

        private String s3BackupMode;

        private S3DestinationConfiguration s3BackupConfiguration;

        private DataFormatConversionConfiguration dataFormatConversionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedS3DestinationConfiguration model) {
            roleARN(model.roleARN);
            bucketARN(model.bucketARN);
            prefix(model.prefix);
            errorOutputPrefix(model.errorOutputPrefix);
            bufferingHints(model.bufferingHints);
            compressionFormat(model.compressionFormat);
            encryptionConfiguration(model.encryptionConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            processingConfiguration(model.processingConfiguration);
            s3BackupMode(model.s3BackupMode);
            s3BackupConfiguration(model.s3BackupConfiguration);
            dataFormatConversionConfiguration(model.dataFormatConversionConfiguration);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getErrorOutputPrefix() {
            return errorOutputPrefix;
        }

        @Override
        public final Builder errorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        public final void setErrorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final String getCompressionFormatAsString() {
            return compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat == null ? null : compressionFormat.toString());
            return this;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final String getS3BackupModeAsString() {
            return s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(S3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationConfiguration.Builder getS3BackupConfiguration() {
            return s3BackupConfiguration != null ? s3BackupConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder s3BackupConfiguration(S3DestinationConfiguration s3BackupConfiguration) {
            this.s3BackupConfiguration = s3BackupConfiguration;
            return this;
        }

        public final void setS3BackupConfiguration(S3DestinationConfiguration.BuilderImpl s3BackupConfiguration) {
            this.s3BackupConfiguration = s3BackupConfiguration != null ? s3BackupConfiguration.build() : null;
        }

        public final DataFormatConversionConfiguration.Builder getDataFormatConversionConfiguration() {
            return dataFormatConversionConfiguration != null ? dataFormatConversionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
            return this;
        }

        public final void setDataFormatConversionConfiguration(
                DataFormatConversionConfiguration.BuilderImpl dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration != null ? dataFormatConversionConfiguration
                    .build() : null;
        }

        @Override
        public ExtendedS3DestinationConfiguration build() {
            return new ExtendedS3DestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
