/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to specify the type and Amazon Resource Name (ARN) of the CMK needed for Server-Side Encryption (SSE).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliveryStreamEncryptionConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<DeliveryStreamEncryptionConfigurationInput.Builder, DeliveryStreamEncryptionConfigurationInput> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeliveryStreamEncryptionConfigurationInput::keyARN)).setter(setter(Builder::keyARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyARN").build()).build();

    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeliveryStreamEncryptionConfigurationInput::keyTypeAsString)).setter(setter(Builder::keyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyARN;

    private final String keyType;

    private DeliveryStreamEncryptionConfigurationInput(BuilderImpl builder) {
        this.keyARN = builder.keyARN;
        this.keyType = builder.keyType;
    }

    /**
     * <p>
     * If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon Resource Name
     * (ARN) of the CMK. If you set <code>KeyType</code> to <code>AWS_OWNED_CMK</code>, Kinesis Data Firehose uses a
     * service-account CMK.
     * </p>
     * 
     * @return If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon
     *         Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to <code>AWS_OWNED_CMK</code>, Kinesis
     *         Data Firehose uses a service-account CMK.
     */
    public String keyARN() {
        return keyARN;
    }

    /**
     * <p>
     * Indicates the type of customer master key (CMK) to use for encryption. The default setting is
     * <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
     * (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
     * <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant
     * that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and
     * decryption. Kinesis Data Firehose manages that grant.
     * </p>
     * <p>
     * When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is already
     * encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for
     * retirement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of customer master key (CMK) to use for encryption. The default setting is
     *         <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
     *         Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
     *         <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation
     *         <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to
     *         create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform
     *         encryption and decryption. Kinesis Data Firehose manages that grant. </p>
     *         <p>
     *         When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
     *         already encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the
     *         old CMK for retirement.
     * @see KeyType
     */
    public KeyType keyType() {
        return KeyType.fromValue(keyType);
    }

    /**
     * <p>
     * Indicates the type of customer master key (CMK) to use for encryption. The default setting is
     * <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
     * (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
     * <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant
     * that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and
     * decryption. Kinesis Data Firehose manages that grant.
     * </p>
     * <p>
     * When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is already
     * encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for
     * retirement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of customer master key (CMK) to use for encryption. The default setting is
     *         <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
     *         Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
     *         <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation
     *         <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to
     *         create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform
     *         encryption and decryption. Kinesis Data Firehose manages that grant. </p>
     *         <p>
     *         When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
     *         already encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the
     *         old CMK for retirement.
     * @see KeyType
     */
    public String keyTypeAsString() {
        return keyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyARN());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamEncryptionConfigurationInput)) {
            return false;
        }
        DeliveryStreamEncryptionConfigurationInput other = (DeliveryStreamEncryptionConfigurationInput) obj;
        return Objects.equals(keyARN(), other.keyARN()) && Objects.equals(keyTypeAsString(), other.keyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeliveryStreamEncryptionConfigurationInput").add("KeyARN", keyARN())
                .add("KeyType", keyTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyARN":
            return Optional.ofNullable(clazz.cast(keyARN()));
        case "KeyType":
            return Optional.ofNullable(clazz.cast(keyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryStreamEncryptionConfigurationInput, T> g) {
        return obj -> g.apply((DeliveryStreamEncryptionConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeliveryStreamEncryptionConfigurationInput> {
        /**
         * <p>
         * If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon Resource
         * Name (ARN) of the CMK. If you set <code>KeyType</code> to <code>AWS_OWNED_CMK</code>, Kinesis Data Firehose
         * uses a service-account CMK.
         * </p>
         * 
         * @param keyARN
         *        If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon
         *        Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to <code>AWS_OWNED_CMK</code>, Kinesis
         *        Data Firehose uses a service-account CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyARN(String keyARN);

        /**
         * <p>
         * Indicates the type of customer master key (CMK) to use for encryption. The default setting is
         * <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
         * (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
         * <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a
         * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a
         * grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and
         * decryption. Kinesis Data Firehose manages that grant.
         * </p>
         * <p>
         * When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is already
         * encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for
         * retirement.
         * </p>
         * 
         * @param keyType
         *        Indicates the type of customer master key (CMK) to use for encryption. The default setting is
         *        <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
         *        Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a>
         *        with <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS
         *        operation <a
         *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to
         *        create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to
         *        perform encryption and decryption. Kinesis Data Firehose manages that grant. </p>
         *        <p>
         *        When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
         *        already encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the
         *        old CMK for retirement.
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(String keyType);

        /**
         * <p>
         * Indicates the type of customer master key (CMK) to use for encryption. The default setting is
         * <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
         * (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
         * <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a
         * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a
         * grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and
         * decryption. Kinesis Data Firehose manages that grant.
         * </p>
         * <p>
         * When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is already
         * encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for
         * retirement.
         * </p>
         * 
         * @param keyType
         *        Indicates the type of customer master key (CMK) to use for encryption. The default setting is
         *        <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
         *        Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a>
         *        with <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS
         *        operation <a
         *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to
         *        create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to
         *        perform encryption and decryption. Kinesis Data Firehose manages that grant. </p>
         *        <p>
         *        When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
         *        already encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the
         *        old CMK for retirement.
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(KeyType keyType);
    }

    static final class BuilderImpl implements Builder {
        private String keyARN;

        private String keyType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamEncryptionConfigurationInput model) {
            keyARN(model.keyARN);
            keyType(model.keyType);
        }

        public final String getKeyARN() {
            return keyARN;
        }

        @Override
        public final Builder keyARN(String keyARN) {
            this.keyARN = keyARN;
            return this;
        }

        public final void setKeyARN(String keyARN) {
            this.keyARN = keyARN;
        }

        public final String getKeyTypeAsString() {
            return keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public DeliveryStreamEncryptionConfigurationInput build() {
            return new DeliveryStreamEncryptionConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
