/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.Serializer;
import software.amazon.awssdk.services.firehose.transform.OrcSerDeUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.ParquetSerDeUnmarshaller;

public class SerializerUnmarshaller
implements Unmarshaller<Serializer, JsonUnmarshallerContext> {
    private static final SerializerUnmarshaller INSTANCE = new SerializerUnmarshaller();

    public Serializer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Serializer.Builder serializerBuilder = Serializer.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ParquetSerDe", targetDepth)) {
                    context.nextToken();
                    serializerBuilder.parquetSerDe(ParquetSerDeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("OrcSerDe", targetDepth)) {
                    context.nextToken();
                    serializerBuilder.orcSerDe(OrcSerDeUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Serializer)serializerBuilder.build();
    }

    public static SerializerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

