/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.SchemaConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SchemaConfigurationMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").isBinary(false).build();
    private static final SchemaConfigurationMarshaller INSTANCE = new SchemaConfigurationMarshaller();

    private SchemaConfigurationMarshaller() {
    }

    public static SchemaConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SchemaConfiguration schemaConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)schemaConfiguration, (String)"schemaConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)schemaConfiguration.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)schemaConfiguration.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)schemaConfiguration.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)schemaConfiguration.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)schemaConfiguration.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)schemaConfiguration.versionId(), VERSIONID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

