/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.ParquetSerDe;

public class ParquetSerDeUnmarshaller
implements Unmarshaller<ParquetSerDe, JsonUnmarshallerContext> {
    private static final ParquetSerDeUnmarshaller INSTANCE = new ParquetSerDeUnmarshaller();

    public ParquetSerDe unmarshall(JsonUnmarshallerContext context) throws Exception {
        ParquetSerDe.Builder parquetSerDeBuilder = ParquetSerDe.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BlockSizeBytes", targetDepth)) {
                    context.nextToken();
                    parquetSerDeBuilder.blockSizeBytes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("PageSizeBytes", targetDepth)) {
                    context.nextToken();
                    parquetSerDeBuilder.pageSizeBytes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Compression", targetDepth)) {
                    context.nextToken();
                    parquetSerDeBuilder.compression((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EnableDictionaryCompression", targetDepth)) {
                    context.nextToken();
                    parquetSerDeBuilder.enableDictionaryCompression((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxPaddingBytes", targetDepth)) {
                    context.nextToken();
                    parquetSerDeBuilder.maxPaddingBytes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("WriterVersion", targetDepth)) {
                    context.nextToken();
                    parquetSerDeBuilder.writerVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ParquetSerDe)parquetSerDeBuilder.build();
    }

    public static ParquetSerDeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

