/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.OutputFormatConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputFormatConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> SERIALIZER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Serializer").isBinary(false).build();
    private static final OutputFormatConfigurationMarshaller INSTANCE = new OutputFormatConfigurationMarshaller();

    private OutputFormatConfigurationMarshaller() {
    }

    public static OutputFormatConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputFormatConfiguration outputFormatConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputFormatConfiguration, (String)"outputFormatConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputFormatConfiguration.serializer(), SERIALIZER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

