/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.OrcSerDe;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OrcSerDeMarshaller {
    private static final MarshallingInfo<Integer> STRIPESIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StripeSizeBytes").isBinary(false).build();
    private static final MarshallingInfo<Integer> BLOCKSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockSizeBytes").isBinary(false).build();
    private static final MarshallingInfo<Integer> ROWINDEXSTRIDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowIndexStride").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLEPADDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnablePadding").isBinary(false).build();
    private static final MarshallingInfo<Double> PADDINGTOLERANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaddingTolerance").isBinary(false).build();
    private static final MarshallingInfo<String> COMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compression").isBinary(false).build();
    private static final MarshallingInfo<List> BLOOMFILTERCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BloomFilterColumns").isBinary(false).build();
    private static final MarshallingInfo<Double> BLOOMFILTERFALSEPOSITIVEPROBABILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BloomFilterFalsePositiveProbability").isBinary(false).build();
    private static final MarshallingInfo<Double> DICTIONARYKEYTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DictionaryKeyThreshold").isBinary(false).build();
    private static final MarshallingInfo<String> FORMATVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FormatVersion").isBinary(false).build();
    private static final OrcSerDeMarshaller INSTANCE = new OrcSerDeMarshaller();

    private OrcSerDeMarshaller() {
    }

    public static OrcSerDeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OrcSerDe orcSerDe, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)orcSerDe, (String)"orcSerDe");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)orcSerDe.stripeSizeBytes(), STRIPESIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.blockSizeBytes(), BLOCKSIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.rowIndexStride(), ROWINDEXSTRIDE_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.enablePadding(), ENABLEPADDING_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.paddingTolerance(), PADDINGTOLERANCE_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.compressionAsString(), COMPRESSION_BINDING);
            protocolMarshaller.marshall(orcSerDe.bloomFilterColumns(), BLOOMFILTERCOLUMNS_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.bloomFilterFalsePositiveProbability(), BLOOMFILTERFALSEPOSITIVEPROBABILITY_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.dictionaryKeyThreshold(), DICTIONARYKEYTHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)orcSerDe.formatVersionAsString(), FORMATVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

