/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OpenXJsonSerDeMarshaller {
    private static final MarshallingInfo<Boolean> CONVERTDOTSINJSONKEYSTOUNDERSCORES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConvertDotsInJsonKeysToUnderscores").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CASEINSENSITIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaseInsensitive").isBinary(false).build();
    private static final MarshallingInfo<Map> COLUMNTOJSONKEYMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnToJsonKeyMappings").isBinary(false).build();
    private static final OpenXJsonSerDeMarshaller INSTANCE = new OpenXJsonSerDeMarshaller();

    private OpenXJsonSerDeMarshaller() {
    }

    public static OpenXJsonSerDeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OpenXJsonSerDe openXJsonSerDe, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)openXJsonSerDe, (String)"openXJsonSerDe");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)openXJsonSerDe.convertDotsInJsonKeysToUnderscores(), CONVERTDOTSINJSONKEYSTOUNDERSCORES_BINDING);
            protocolMarshaller.marshall((Object)openXJsonSerDe.caseInsensitive(), CASEINSENSITIVE_BINDING);
            protocolMarshaller.marshall(openXJsonSerDe.columnToJsonKeyMappings(), COLUMNTOJSONKEYMAPPINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

